

UpdateFlightDisplay:

	rvsetflagtrue flagMutePwm

	call LcdClear12x16


	;--- print armed status ---

	rvbrflagfalse flagArmed, udp3

	lrv X1, 34				;Armed
	lrv Y1, 22
	ldz upd5*2
	call PrintString

	clr t					;banner
	sts X1, t
	ldi t, 19
	sts Y1, t
	ldi t, 127
	sts X2, t
	ldi t, 40
	sts Y2, t
	lrv PixelType, 0
	call HilightRectangle

	rjmp udp22

udp3:	lrv X1, 38				;Safe
	ldz upd2*2
	call PrintString
udp22:


	;--- Print footer if safe ---

	rvbrflagtrue flagArmed, udp20

	lrv X1, 102				;footer
	lrv Y1, 57
	lrv FontSelector, f6x8
	ldz upd1*2
	call PrintString

	rvbrflagfalse flagArmed, udp23		;skip the rest if armed
udp20:	rjmp udp21
	


udp23:	;--- Print status ----

	lrv X1, 0
	lrv Y1, 17
	ldz sta20*2
	lds t, status
	call PrintFromStringArray

	lds t, Status				;print "Ready for tuning." if status is OK and Tuning Mode is active
	tst t
	brne udp51

	lds t, TuningMode
	tst t
	breq udp52

	ldi t, 1
udp52:	ldz udp8*2
	call PrintFromStringArray


udp51:	;--- print Selflevel status ---

	lrv X1, 0				;self-level
	lrv Y1, 27
	ldz udp9*2
	call PrintString
	rvbrflagfalse flagSelfLevelOn, udp50

	ldz udp10*2				;ON
	call PrintString
	rvbrflagfalse flagSlStickMixing, udp13

	ldz udp12*2
	call PrintString			;MIX
	lds t, SlStickMixingChar
	call PrintChar				;L, M or H
	rjmp udp13

udp50:	ldz udp11*2				;OFF
	call PrintString


udp13:	;--- Print battery voltage

	b16ldi Temp, 6.875067139
	b16mul Temp, BatteryVoltage, Temp
	b16fdiv Temp, 8

	lrv X1, 0				;Battery
	lrv Y1, 36
	ldz udp30*2
	call PrintString

	b16load Temp
 	call Print16Signed 
	
	ldi t,'.'
	call PrintChar

	mov xl, yh
	clr xh
	b16store Temp

	b16ldi Temper, 0.0390625
	b16mul Temp, Temp, Temper

	b16load Temp
 	call Print16Signed
	ldz udp31*2				;V
	call PrintString


	;---

udp21:	call LcdUpdate

	rvsetflagfalse flagMutePwm

	ret


upd1:	.db "MENU",0,0
upd2:	.db 69, 58, 61, 60, 0, 0		;the text "SAFE" in the mangled 12x16 font
upd5:	.db 58, 68, 65, 60, 59, 0		;the text "ARMED" in the mangled 12x16 font

udp6:	.db "!", 0
udp7:	.db " for tuning.", 0, 0

udp8:	.dw udp6*2, udp7*2

udp9:	.db "Self-level: ", 0, 0
udp10:	.db "ON ", 0
udp11:	.db "OFF", 0
udp12:	.db "MIX ", 0, 0


udp30:	.db "Battery   : ", 0, 0
udp31:	.db " V", 0, 0


sta0:	.db "Ready", 0
sta1:	.db "No CPPM input!", 0, 0
sta2:	.db "ACC not calibrated!", 0
sta3:	.db "Sanity check failed!", 0, 0
sta4:	.db "No motor layout!", 0, 0



sta20:	.dw sta0*2, sta1*2, sta2*2, sta3*2, sta4*2



