
IsrRoll:

	in SregSaver, sreg
	sbis pind,3			;rising or falling?
	rjmp rx1

	lds tt, tcnt1l			;rising, store the start value
	sts RollStartL, tt
	lds tt, tcnt1h
	sts RollStartH, tt
	
	clr tt
	sts RollDcnt, tt

	out sreg, SregSaver		;exit	
	reti

rx1:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, RollStartL
	sub tt, treg
	sts RollL, tt

	lds tt, tcnt1h
	lds treg, RollStartH
	sbc tt, treg
	sts RollH, tt

	out sreg, SregSaver		;exit	
	reti



IsrPitch:

	in SregSaver, sreg

	sbis pind,2			;rising or falling?
	rjmp rx2

	lds tt, tcnt1l			;rising, store the start value
	sts PitchStartL, tt
	lds tt, tcnt1h
	sts PitchStartH, tt

	clr tt
	sts PitchDcnt, tt
	
	out sreg, SregSaver		;exit	
	reti

rx2:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, PitchStartL
	sub tt, treg
	sts PitchL, tt

	lds tt, tcnt1h
	lds treg, PitchStartH
	sbc tt, treg
	sts PitchH, tt

	out sreg, SregSaver		;exit	
	reti



IsrThrottle:

	in SregSaver, sreg

	sbis pind,0			;rising or falling?
	rjmp rx3

	lds tt, tcnt1l			;rising, store the start value
	sts ThrottleStartL, tt
	lds tt, tcnt1h
	sts ThrottleStartH, tt
	
	clr tt
	sts ThrottleDcnt, tt

	out sreg, SregSaver		;exit	
	reti

rx3:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, ThrottleStartL
	sub tt, treg
	sts ThrottleL, tt

	lds tt, tcnt1h
	lds treg, ThrottleStartH
	sbc tt, treg
	sts ThrottleH, tt

	out sreg, SregSaver		;exit	
	reti



IsrYaw:

	in SregSaver, sreg

	sbis pinb,2			;rising or falling?
	rjmp rx4

	lds tt, tcnt1l			;rising, store the start value
	sts YawStartL, tt
	lds tt, tcnt1h
	sts YawStartH, tt

	clr tt
	sts YawDcnt, tt
	
	out sreg, SregSaver		;exit	
	reti

rx4:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, YawStartL
	sub tt, treg
	sts YawL, tt

	lds tt, tcnt1h
	lds treg, YawStartH
	sbc tt, treg
	sts YawH, tt

	out sreg, SregSaver		;exit	
	reti



IsrAux:

	in SregSaver, sreg

	sbis pinb,0			;rising or falling?
	rjmp rx5

	lds tt, tcnt1l			;rising, store the start value
	sts AuxStartL, tt
	lds tt, tcnt1h
	sts AuxStartH, tt

	clr tt
	sts AuxDcnt, tt
	
	out sreg, SregSaver		;exit	
	reti

rx5:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, AuxStartL
	sub tt, treg
	sts AuxL, tt

	lds tt, tcnt1h
	lds treg, AuxStartH
	sbc tt, treg
	sts AuxH, tt

	out sreg, SregSaver		;exit	
	reti


	;---


GetRxChannels:

	;--- Roll ---

	cli				;get roll channel value
	lds xl, RollL
	lds xh, RollH
	sei

	rcall Sanitize			;sanitize
	clr yh				;store in register
	b16store RxRoll

	
	;--- Pitch

	cli				;get Pitch channel value
	lds xl, PitchL
	lds xh, PitchH
	sei

	rcall Sanitize			;sanitize
	clr yh				;store in register
	b16store RxPitch


	;--- Throttle ---

	cli				;get Throttle channel value
	lds xl, ThrottleL
	lds xh, ThrottleH
	sei

	rvsetflagfalse flagThrottleZero

	rcall Xabs			;X = ABS(X)

	ldz 2875			;X = X - 2875 (1.15ms)
	sub xl, zl
	sbc xh, zh

	ldz 0				;X < 0 ?
	cp  xl, zl
	cpc xh, zh
	brge gt8m8

	rjmp rx30			;yes, set to zero

gt8m8:	ldz 3125			;X > 3125? (1.25ms)
	cp  xl, zl
	cpc xh, zh
	brlt gt7m2

rx30:	ldx 0				;Yes, set to zero
	rvsetflagtrue flagThrottleZero

gt7m2:	clr yh				;store in register
	b16store RxThrottle


	;--- Yaw ---

	cli				;get Yaw channel value
	lds xl, YawL
	lds xh, YawH
	sei

	rcall Sanitize			;sanitize

	clr yh				;store in register
	b16store RxYaw

	
	;--- AUX ---

	cli				;get Aux channel value
	lds xl, AuxL
	lds xh, AuxH
	sei

	rcall Sanitize			;sanitize

	clr yl				;detect AUX switch position
	ldz -600
	cp  xl, zl
	cpc xh, zh
	brlt rx35			;AUX switch is in position #1

	inc yl
	ldz -200
	cp  xl, zl
	cpc xh, zh
	brlt rx35			;AUX switch is in position #2

	inc yl
	ldz 200
	cp  xl, zl
	cpc xh, zh
	brlt rx35			;AUX switch is in position #3

	inc yl
	ldz 600
	cp  xl, zl
	cpc xh, zh
	brlt rx35			;AUX switch is in position #4

	inc yl				;AUX switch is in position #5

rx35:	sts AuxSwitchPosition, yl
	clr yh				;store in register
	b16store RxAux



	;--- Check rx ---

	rvsetflagtrue flagRollValid	
	rvsetflagtrue flagPitchValid	
	rvsetflagtrue flagThrottleValid	
	rvsetflagtrue flagYawValid	
	rvsetflagtrue flagAuxValid	

	rvinc RollDcnt				;signal timed out?
	rvcp RollDcnt, RxTimeoutLimit
	brlo rx25

	rvdec RollDcnt
	rvsetflagfalse flagRollValid		;Yes, set flag to false and set value to 0
	b16clr RxRoll

rx25:	rvinc PitchDcnt				;signal timed out?
	rvcp PitchDcnt, RxTimeoutLimit
	brlo rx26

	rvdec PitchDcnt
	rvsetflagfalse flagPitchValid		;Yes, set flag to false and set value to 0
	b16clr RxPitch

rx26:	rvinc ThrottleDcnt			;signal timed out?
	rvcp ThrottleDcnt, RxTimeoutLimit
	brlo rx27

	rvdec ThrottleDcnt
	rvsetflagfalse flagThrottleValid	;Yes, set flag to false and set value to 0
	b16clr RxThrottle
	rvsetflagtrue flagThrottleZero

rx27:	rvinc YawDcnt				;signal timed out?
	rvcp YawDcnt, RxTimeoutLimit
	brlo rx28

	rvdec YawDcnt
	rvsetflagfalse flagYawValid		;Yes, set flag to false and set value to 0
	b16clr RxYaw

rx28:	rvinc AuxDcnt				;signal timed out?
	rvcp AuxDcnt, RxTimeoutLimit
	brlo rx29

	rvdec AuxDcnt
	rvsetflagfalse flagAuxValid		;Yes, set flag to false and set value to 0
	b16clr RxAux

	lds t, AuxSwitchPosition		;select AUX function #1. PS! Setting this value multiple times will cause Alarm problems (AuxBeepDelay)
	tst t
	breq rx29

	clr t
	sts AuxSwitchPosition, t
	ser t					;make sure the AUX switch function will be updated
	sts AuxSwitchPositionOld, t

rx29:	ret



	;----

Sanitize:

	rcall Xabs	;X = ABS(X)

	ldz 3750	;X = X - 3750 (1.5ms)
	sub xl, zl
	sbc xh, zh

	ldz -1750	;X < -1750?  (0.7ms)
	cp  xl, zl
	cpc xh, zh
	brlt gt1m2

	ldz 1750	;X > 1750?
	cp  xl, zl
	cpc xh, zh
	brge gt1m2

	ret		;No, exit

gt1m2:	ldx 0		;Yes, set to zero
	ret





Xabs:

	tst xh		;X = ABS(X)
	brpl xa1

	com xl
	com xh
	
	ldi t,1
	add xl,t
	clr t
	adc xh,t

xa1:	ret




