
FlightInit:

	rcall LoadMixerTable		;copy Mixertable from EE to RAM

	ldz EeParameterTable		;copy and scale PI gain and limits from EE to 16.8 variables
	call fli2
	b16mov PgainRoll, Temp
	b16mov PgainRollOrg, Temp

	call fli2
	call fli5
	b16mov PlimitRoll, Temp

	call fli2
	b16mov IgainRollOrg, Temp
	call TempDiv16
	b16mov IgainRoll, Temp

	call fli2
	call fli5
	b16mov IlimitRoll, Temp

	call fli2
	b16mov PgainPitch, Temp
	b16mov PgainPitchOrg, Temp

	call fli2
	call fli5
	b16mov PlimitPitch, Temp

	call fli2
	b16mov IgainPitchOrg, Temp
	call TempDiv16
	b16mov IgainPitch, Temp

	call fli2
	call fli5
	b16mov IlimitPitch, Temp

	call fli2
	b16mov PgainYaw, Temp
	b16mov PgainYawOrg, Temp

	call fli2
	call fli5
	b16mov PlimitYaw, Temp

	call fli2
	b16mov IgainYawOrg, Temp
	call TempDiv16
	b16mov IgainYaw, Temp

	call fli2
	call fli5
	b16mov IlimitYaw, Temp


	rcall UpdateOutputTypeAndRate


	b16ldi Temp, 2220			;preload the servo filters
	lrv Index, 0
fli8:	b16store_array FilteredOut1, Temp
	rvinc Index
	rvcpi Index, 8
	brne fli8

	ldz eeSelflevelPgain
	call fli2
	b16mov SelflevelPgain, Temp
	b16mov SelfLevelPgainOrg, Temp

	call fli2				;eeSelflevelPlimit
	b16ldi Temper, 10
	b16mul SelflevelPlimit, Temp, Temper

	call fli2				;eeAccTrimRoll
	b16fdiv Temp, 3
	b16mov AccTrimRoll, Temp

	call fli2				;eeAccTrimPitch
	b16fdiv Temp, 3
	b16mov AccTrimPitch, Temp


	ldz eeEscLowLimit
	call fli2
	b16ldi Temper, 44.4
	b16mul EscLowLimit, Temp, Temper

	call fli2				;eeHeightDampeningGain
	b16mov HeightDampeningGain, Temp

	call fli2				;eeHeightDampeningLimit
	call fli5
	b16mov HeightDampeningLimit, Temp

	call fli2				;eeBattAlarmVoltage
	b16ldi Temper, 3.7236
	b16mul BattAlarmVoltage, Temp, Temper

	call fli2				;eeServoFilter
	b16ldi Temper, 100
	b16sub ServoFilter, Temper, Temp
	b16fdiv ServoFilter, 7


	rcall LoadStickScalingValues


	ldz eeCamRollGain
	call fli2
	b16mov CamRollGainOrg, Temp
	call TempDiv16
	b16mov CamRollGain, Temp

	call fli2				;eeCamPitchGain
	b16mov CamPitchGainOrg, Temp
	call TempDiv16
	b16mov CamPitchGain, Temp

	call ReadEeprom				;eeCamServoMixing
	sts CamServoMixing, t



	ldz EeSensorCalData			;load calibration data
	call GetEeVariable168
	b16store AccXZero
	call GetEeVariable168
	b16store AccYZero
	call GetEeVariable168
	b16store AccZZero


	rcall ReadLinkRollPitchFlag
	rcall CheckTuningMode

	ldz eeAutoDisarm
	call ReadEeprom
	sts flagAutoDisarm, t


	ldz eeSlPgainRate			;SL Stick Mixing
	call ReadEeprom
	cpi t, 1				;low?
	breq fli32

	cpi t, 3				;high?
	breq fli33

	b16ldi SelflevelPgainRate, 0.1		;neither, setting SL P-gain rate to MEDIUM
	ldi t, 'M'
	rjmp fli34

fli32:	b16ldi SelflevelPgainRate, 0.05		;setting SL P-gain rate to LOW
	ldi t, 'L'
	rjmp fli34

fli33:	b16ldi SelflevelPgainRate, 0.2		;setting SL P-gain rate to HIGH
	ldi t, 'H'

fli34:	sts SlStickMixingChar, t		;character (M/L/H) to be displayed on the SAFE screen

	lrv OutputRateDividerCounter, 1
	lrv OutputRateDivider, 5		;slow rate divider. f = 400 / OutputRateDivider

	rvsetflagtrue flagLcdUpdate

	clr t
	sts flagMutePwm, t

	sts flagArmed, t
	sts flagArmedOldState, t

	sts ButtonDelay, t

	sts flagSlOn, t

	sts flagGeneralBuzzerOn, t
	sts flagLvaBuzzerOn, t
	sts flagDebugBuzzerOn, t
	sts flagGyrosCalibrated, t
	
	b16set AutoDisarmDelay

	b16set BeeperDelay

	b16set ArmedBeepDds

	b16set NoActivityTimer
	b16set NoActivityDds

	b16set LiveUpdateTimer

	b16set EulerAngleRoll
	b16set EulerAnglePitch

	rcall Initialize3dVector		;set 3d vector to point straigth up

	b16ldi BatteryVoltageLowpass, 1023

	ldz eeMotorLayoutOk			;motor layout loaded?
	call ReadEeprom
	brflagtrue t, fli4
	lrv Status, 5				;no, will display an error and refuse arming
	ret

fli4:	lrv Status, 0
	ldz eeSensorsCalibrated			;sensors calibrated?
	call ReadEeprom
	brflagtrue t, fli11
	lrv Status, 3
	ret

fli11:	call SanityCheck
	ret


	;---

Initialize3dVector:
	b824clr VectorX				;set 3d vector to point straigth up
	b824clr VectorY
	b824ldi VectorZ, 1
	ret


	;---

TempDiv16:
	b16fdiv Temp, 4		;divide temp by 16
	ret


	;---

fli2:	call GetEeVariable16	;Temp = (Z+)
	clr yh
	b16store Temp
	ret

fli5:	b16ldi Temper, 113.664	;most limit values (0-100%) are scaled with 113.664 to fit to the 11366.4 full throttle value
	b16mul Temp, Temp, Temper
	ret

fli9:	b16ldi Temper, 44.4
	b16mul Temp, Temp, Temper
	ret

	;---

SanityCheck:
	call LcdClear6x8

	lrv X1, 0
	lrv Y1, 15

;	CheckLimit SelflevelPgain, 0, 501, san1
;	CheckLimit SelflevelPlimit, 0, 3411, san1			;30%

	CheckLimit EscLowLimit, 0, 888, san1				;20%

	CheckLimit HeightDampeningGain, 0, 501 ,san1
	CheckLimit HeightDampeningLimit, 0, 3411 ,san1			;30%


	CheckLimit GyroRollZero, GyroLowLimit, GyroHighLimit, san2
	CheckLimit GyroPitchZero, GyroLowLimit, GyroHighLimit, san2
	CheckLimit GyroYawZero, GyroLowLimit, GyroHighLimit, san2

	CheckLimit AccXZero, AccLowLimit, AccHighLimit, san2
	CheckLimit AccYZero, AccLowLimit, AccHighLimit, san2
	CheckLimit AccZZero, AccLowLimit, AccHighLimit, san2

	call AdcRead
	call AdcRead

	CheckLimit GyroRoll, 100, 900, san3
	CheckLimit GyroPitch, 100, 900, san3
	CheckLimit GyroYaw, 100, 900, san3

	CheckLimit AccX, 100, 900, san3
	CheckLimit AccY, 100, 900, san3
	CheckLimit AccZ, 100, 900, san3

	ret 				;No errors, return


san1:	clr t				;print error message "One or more settings are out of limits."
	ldi yh, 9
	call PrintSanityMessage
	rjmp san4

san2:	ldi t, 2			;print error message "Sensor calibration data out of limits."
	ldi yh, 9
	call PrintSanityMessage
	rjmp san4

san3:	ldi t, 4			;print error message "Sensor raw data are out of limits."
	ldi yh, 9
	call PrintSanityMessage

san4:	lrv Status, 4			;Error

	lrv X1, 35			;print "WARNING" header and "Check your settings."
	lrv Y1, 1
	ldi t, 6
	ldi yh, 39
	call PrintSanityMessage

	call PrintContinueFooter

	call LcdUpdate

	BuzzerOn
	ldi yh, 39
san5:	ldi yl, 0
	call wms
	dec yh
	brne san5
	BuzzerOff

san6:	call GetButtonsBlocking
	cpi t, 0x01			;CONTINUE?
	brne san6

	ret





limit:
	cp  xl, yl	;less?
	cpc xh, yh
	brlt lim1
	cp  xl, zl	;greater?
	cpc xh, zh
	brge lim1
	clc		;OK
	ret

lim1:	sec		;not OK
	ret



	;--- Load stick scaling values from EEPROM --

LoadStickScalingValues:

	ldz eeStickScaleRoll
	call fli2
	call TempDiv16
	b16mov StickScaleRoll, Temp

	call fli2				;eeStickScalePitch
	call TempDiv16
	b16mov StickScalePitch, Temp

	call fli2				;eeStickScaleYaw
	call TempDiv16
	b16mov StickScaleYaw, Temp

	call fli2				;eeStickScaleThrottle
	call TempDiv16
	b16mov StickScaleThrottle, Temp
	ret




	;--- Copy Mixertable from EEPROM to RAM ---

LoadMixerTable:

	ldi yl, 64
	ldx RamMixerTable
	ldz EeMixerTable
mt1:	call ReadEeprom
	st x+, t
	adiw z, 1
	dec yl
	brne mt1

	ret



	;--- Prepare the OutputRateBitmask and OutputTypeBitmask variables ---

UpdateOutputTypeAndRate:

	ldi yl, 8
	ldz RamMixerTable 
otr1:	ldd t, z + MixvalueFlags

	clc
	sbrc t, bMixerFlagRate
	sec
	ror xl

	clc
	sbrc t, bMixerFlagType
	sec
	ror xh

	adiw z, 8
	dec yl
	brne otr1

	sts OutputRateBitmask, xl
	sts OutputTypeBitmask, xh
	ret



	;--- Check and correct TuningMode ---

CheckTuningMode:

	lds t, TuningMode		;set TuningMode to 1 (Aileron) if it is currently set to 2 (Elevator) and roll/pitch are linked
	cpi t, 2
	brne ctm1

	rvbrflagfalse flagRollPitchLink, ctm1

	lds t, TuningMode
	dec t
	sts TuningMode, t
ctm1:	ret



	;--- Read the LinkRollPitch flag from EEPROM ---

ReadLinkRollPitchFlag:

	ldz eeLinkRollPitch
	call ReadEeprom
	sts flagRollPitchLink, t
	ret



	;--- Print two message lines ---

PrintSanityMessage:

	ldi yl, 2	;loop counter

psm1:	push yl
	push t		;register T is the input parameter that decides which messages to print (valid range: 0 - 6)
	push yh		;register YH is the input parameter that decides the line offset increment
	ldz mad10*2
	call PrintFromStringArray
	lrv X1, 0
	lds t, Y1
	pop yh
	add t, yh
	sts Y1, t
	pop t
	inc t
	pop yl
	dec yl
	brne psm1

	ret



mad1:	.db "One or more settings", 0, 0
mad2:	.db "are out of limits.", 0, 0

mad3:	.db "Check your settings!!", 0

mad5:	.db "Sensor calibration", 0, 0
mad6:	.db "data out of limits.", 0

mad7:	.db "Sensor raw data", 0

mad8:	.db "WARNING!", 0, 0

mad10:	.dw mad1*2, mad2*2, mad5*2, mad6*2, mad7*2, mad2*2, mad8*2, mad3*2

;call SerOut16
;ldi xl, 0x0d
;call SerByteOut

