/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.AvrdudeConfigFile;
import avr8_burn_o_mat.AvrdudeProgrammer;
import avr8_burn_o_mat.InterfaceTextOutput;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.prefs.Preferences;

public class AvrdudeControl {
    private String m_avrdude;
    private String m_avrdudeConfig;
    private String m_port = "/dev/parport0";
    private Boolean m_disableAutoErase = false;
    private Boolean m_exitSpecActivated = false;
    private Boolean m_leftResetActivated = false;
    private Boolean m_leftVccActivated = false;
    private Boolean m_disableFuseCheck = false;
    private InterfaceTextOutput m_intfTextOutput;
    private AvrdudeProgrammer m_programmer = new AvrdudeProgrammer("stk200", "par", "STK200");
    private AvrdudeConfigFile m_avrdudeConfigFile = new AvrdudeConfigFile();
    private String m_additionalOptions = "";

    public AvrdudeControl(InterfaceTextOutput intfTextOutput, boolean isUSBtiny) throws IOException {
        this.m_intfTextOutput = intfTextOutput;
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch");
        System.out.println("OS for avrdude settings is: " + os);
        if (os.contains("windows") && !isUSBtiny) {
            this.m_avrdude = String.valueOf(System.getProperty("user.dir")) + "\\lib\\avrdude\\windows\\avrdude.exe";
            this.m_avrdudeConfig = String.valueOf(System.getProperty("user.dir")) + "\\lib\\avrdude\\windows\\avrdude.conf";
        } else if (os.contains("windows") && isUSBtiny) {
            this.m_avrdude = String.valueOf(System.getProperty("user.dir")) + "\\lib\\avrdude\\windows\\usbtiny\\avrdude.exe";
            this.m_avrdudeConfig = String.valueOf(System.getProperty("user.dir")) + "\\lib\\avrdude\\windows\\usbtiny\\avrdude.conf";
        } else if (os.contains("mac") && !isUSBtiny) {
            String path = System.getProperty("java.library.path");
            path = path.substring(0, path.indexOf(":"));
            this.m_avrdude = String.valueOf(path) + "/lib/avrdude/mac/avrdude";
            this.m_avrdudeConfig = String.valueOf(path) + "/lib/avrdude/mac/avrdude.conf";
        } else if (os.contains("mac") && isUSBtiny) {
            String path = System.getProperty("java.library.path");
            path = path.substring(0, path.indexOf(":"));
            this.m_avrdude = String.valueOf(path) + "/lib/avrdude/mac/usbtiny/avrdude";
            this.m_avrdudeConfig = String.valueOf(path) + "/lib/avrdude/mac/usbtiny/avrdude.conf";
        } else if (os.contains("linux")) {
            if (arch.equals("amd64")) {
                this.m_avrdude = String.valueOf(System.getProperty("user.dir")) + "/lib/avrdude/linux64/avrdude";
                this.m_avrdudeConfig = String.valueOf(System.getProperty("user.dir")) + "/lib/avrdude/linux64/avrdude.conf";
            } else if (!isUSBtiny) {
                this.m_avrdude = String.valueOf(System.getProperty("user.dir")) + "/lib/avrdude/linux/avrdude";
                this.m_avrdudeConfig = String.valueOf(System.getProperty("user.dir")) + "/lib/avrdude/linux/avrdude.conf";
            } else {
                this.m_avrdude = String.valueOf(System.getProperty("user.dir")) + "/lib/avrdude/linux/usbtiny/avrdude";
                this.m_avrdudeConfig = String.valueOf(System.getProperty("user.dir")) + "/lib/avrdude/linux/usbtiny/avrdude.conf";
            }
        }
        this.loadPreferences();
    }

    public Vector<AvrdudeProgrammer> getProgrammerList() {
        return this.m_avrdudeConfigFile.getProgrammerList();
    }

    public void savePreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.put("Avrdude", this.m_avrdude);
            prefs.put("AvrdudeConfig", this.m_avrdudeConfig);
            prefs.put("Programmer", this.m_programmer.getId());
            prefs.put("Port", this.m_port);
            prefs.put("AdditionalOptions", this.m_additionalOptions);
            prefs.putBoolean("DisableAutoErase", this.m_disableAutoErase);
            prefs.putBoolean("ExitSpecActivated", this.m_exitSpecActivated);
            prefs.putBoolean("LeftResetActivated", this.m_leftResetActivated);
            prefs.putBoolean("LeftVccActivated", this.m_leftVccActivated);
            prefs.putBoolean("DisableFuseCheck", this.m_disableFuseCheck);
            prefs.flush();
        }
        catch (Exception e) {
            System.err.println("Error while saving preferences: " + e.getMessage());
        }
    }

    public void loadPreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            this.m_port = prefs.get("Port", "/dev/parport0");
            this.m_additionalOptions = prefs.get("AdditionalOptions", "");
            this.m_disableAutoErase = prefs.getBoolean("DisableAutoErase", false);
            this.m_exitSpecActivated = prefs.getBoolean("ExitSpecActivated", false);
            this.m_leftResetActivated = prefs.getBoolean("LeftResetActivated", false);
            this.m_leftVccActivated = prefs.getBoolean("LeftVccActivated", false);
            this.m_disableFuseCheck = prefs.getBoolean("DisableFuseCheck", false);
            String programmer = prefs.get("Programmer", "");
            this.m_avrdudeConfigFile.readAvrdudeConfigFile(this.m_avrdudeConfig);
            Vector<AvrdudeProgrammer> progList = this.m_avrdudeConfigFile.getProgrammerList();
            for (AvrdudeProgrammer p : progList) {
                if (!p.equals(programmer)) continue;
                this.m_programmer = p;
            }
        }
        catch (Exception e) {
            System.err.println("Error while loading preferences: " + e.getMessage());
        }
    }

    public String getAvrdude() {
        return this.m_avrdude;
    }

    public void setAvrdude(String avrdude) {
        this.m_avrdude = avrdude;
    }

    public AvrdudeProgrammer getProgrammer() {
        return this.m_programmer;
    }

    public void setProgrammer(AvrdudeProgrammer programmer) {
        this.m_programmer = programmer;
    }

    public String getPort() {
        return this.m_port;
    }

    public void setPort(String port) {
        this.m_port = port;
    }

    public String getAdditionalOptions() {
        return this.m_additionalOptions;
    }

    public void setAdditionalOptions(String additionalOptions) {
        this.m_additionalOptions = additionalOptions;
    }

    public String getAvrdudeConfig() {
        return this.m_avrdudeConfig;
    }

    public void setAvrdudeConfig(String avrdudeConfig) {
        this.m_avrdudeConfig = avrdudeConfig;
    }

    public void addAdditionalOption(String option) {
        this.m_additionalOptions = this.m_additionalOptions.concat(this.m_additionalOptions.length() > 0 ? " " + option : option);
    }

    public void addAndUpdateAdditionalOptions(String additionalOptions) {
        if (additionalOptions != null) {
            String[] addOptions = additionalOptions.split(" ");
            int i = 0;
            while (i < addOptions.length) {
                if (addOptions[i].startsWith("-")) {
                    if (this.m_additionalOptions.contains(addOptions[i])) {
                        if (i < addOptions.length - 1 && !addOptions[i + 1].startsWith("-")) {
                            int start = this.m_additionalOptions.indexOf(addOptions[i]);
                            int end = (start == 0 ? this.m_additionalOptions.indexOf("-", 1) : this.m_additionalOptions.indexOf("-", start)) - 1;
                            this.m_additionalOptions = String.valueOf(start == 0 ? "" : this.m_additionalOptions.substring(0, start)) + addOptions[i] + " " + addOptions[i + 1] + this.m_additionalOptions.substring(end);
                        }
                    } else if (i < addOptions.length - 1) {
                        if (!addOptions[i + 1].startsWith("-")) {
                            this.addAdditionalOption(String.valueOf(addOptions[i]) + " " + addOptions[i + 1]);
                        } else {
                            this.addAdditionalOption(addOptions[i]);
                        }
                    } else {
                        this.addAdditionalOption(addOptions[i]);
                    }
                }
                ++i;
            }
        }
    }

    private void addAdditionalOptions(Vector<String> cmd) {
        String[] options;
        String[] stringArray = options = this.m_additionalOptions.split(" ");
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            cmd.add(o);
            ++n2;
        }
    }

    private Vector<String> getCmd(AVR avr) {
        Vector<String> cmd = new Vector<String>();
        cmd.add(this.m_avrdude);
        if (this.m_disableFuseCheck.booleanValue()) {
            cmd.add("-u");
        }
        if (this.m_avrdudeConfig.length() > 0) {
            cmd.add("-C");
            cmd.add(this.m_avrdudeConfig);
        }
        cmd.add("-p");
        cmd.add(avr.getCaptionAliasFree());
        cmd.add("-P");
        cmd.add(this.m_port);
        cmd.add("-c");
        cmd.add(this.m_programmer.getId());
        if (this.m_disableAutoErase.booleanValue()) {
            cmd.add("-D");
        }
        if (this.m_exitSpecActivated.booleanValue()) {
            String exitSpec = this.m_leftResetActivated != false ? "reset" : "noreset";
            exitSpec = this.m_leftVccActivated != false ? String.valueOf(exitSpec) + ",vcc" : String.valueOf(exitSpec) + ",novcc";
            cmd.add("-E");
            cmd.add(exitSpec);
        }
        this.addAdditionalOptions(cmd);
        return cmd;
    }

    public void readFuses(AVR avr, String path) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("lfuse:r:%s:r", String.valueOf(path) + "/lfuse.hex"));
        cmd.add("-U");
        cmd.add(String.format("hfuse:r:%s:r", String.valueOf(path) + "/hfuse.hex"));
        int exitValue = this.startAvrdudeFusesReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error reading fuses!");
        }
        FileInputStream fs = new FileInputStream(String.valueOf(path) + "/lfuse.hex");
        int data = fs.read();
        avr.setLfuse(String.valueOf(data));
        fs.close();
        fs = new FileInputStream(String.valueOf(path) + "/hfuse.hex");
        data = fs.read();
        avr.setHfuse(String.valueOf(data));
        fs.close();
    }

    public void writeFuses(AVR avr) throws Exception {
        int exitValue;
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("lfuse:w:%s:m", avr.getLfuse()));
        cmd.add("-U");
        cmd.add(String.format("hfuse:w:%s:m", avr.getHfuse()));
        if (avr.getEfuse() != null) {
            cmd.add("-U");
            cmd.add(String.format("efuse:w:%s:m", avr.getEfuse()));
        }
        if ((exitValue = this.startAvrdudeFusesReadWrite(cmd)) != 0) {
            throw new Exception("Error writing fuses!");
        }
    }

    public void verifyFuses(AVR avr) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("lfuse:v:0x%s:m", avr.getLfuse()));
        cmd.add("-U");
        cmd.add(String.format("hfuse:v:0x%s:m", avr.getHfuse()));
        int exitValue = this.startAvrdudeFusesReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error verifying fuses!");
        }
    }

    public void readFlash(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("flash:r:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error reading flash!");
        }
    }

    public void writeFlash(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("flash:w:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error writing flash!");
        }
    }

    public void verifyFlash(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("flash:v:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error verifying flash!");
        }
    }

    public void readEEPROM(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("eeprom:r:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error reading EEPROM!");
        }
    }

    public void writeEEPROM(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("eeprom:w:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error writing EEPROM!");
        }
    }

    public void verifyEEPROM(AVR avr, String filename, FileFormat fileFormat) throws Exception {
        Vector<String> cmd = this.getCmd(avr);
        cmd.add("-U");
        cmd.add(String.format("eeprom:v:%s:%s", filename, this.FileFormat2AvrdudeOption(fileFormat)));
        int exitValue = this.startAvrdudeFlashReadWrite(cmd);
        if (exitValue != 0) {
            throw new Exception("Error verifying EEPROM!");
        }
    }

    private int startAvrdudeFusesReadWrite(Vector<String> cmd) throws Exception {
        this.m_intfTextOutput.println("");
        for (String s : cmd) {
            this.m_intfTextOutput.print(String.valueOf(s) + " ");
        }
        this.m_intfTextOutput.println("");
        String[] cmdArray = new String[cmd.size()];
        cmd.toArray(cmdArray);
        final Process p = Runtime.getRuntime().exec(cmdArray);
        new Thread(){

            @Override
            public void run() {
                BufferedInputStream bis = new BufferedInputStream(p.getErrorStream());
                try {
                    int line;
                    while ((line = bis.read()) != -1) {
                        AvrdudeControl.this.m_intfTextOutput.print(String.valueOf((char)line));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                BufferedInputStream bis = new BufferedInputStream(p.getInputStream());
                try {
                    int line;
                    while ((line = bis.read()) != -1) {
                        AvrdudeControl.this.m_intfTextOutput.print(String.valueOf((char)line));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        KKMulticopterFlashTool.getLogger().log(Level.INFO, this.m_intfTextOutput.getText());
        System.out.println("start waiting for the process to finish.");
        p.waitFor();
        System.out.println("process finished.");
        return p.exitValue();
    }

    private int startAvrdudeFlashReadWrite(Vector<String> cmd) throws Exception {
        this.m_intfTextOutput.println("");
        for (String s : cmd) {
            this.m_intfTextOutput.print(String.valueOf(s) + " ");
        }
        this.m_intfTextOutput.println("");
        String[] cmdArray = new String[cmd.size()];
        cmd.toArray(cmdArray);
        final Process p = Runtime.getRuntime().exec(cmdArray);
        new Thread(){

            @Override
            public void run() {
                BufferedInputStream bis = new BufferedInputStream(p.getErrorStream());
                try {
                    int line;
                    while ((line = bis.read()) != -1) {
                        AvrdudeControl.this.m_intfTextOutput.print(String.valueOf((char)line));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                BufferedInputStream bis = new BufferedInputStream(p.getInputStream());
                try {
                    int line;
                    while ((line = bis.read()) != -1) {
                        AvrdudeControl.this.m_intfTextOutput.print(String.valueOf((char)line));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        p.waitFor();
        return p.exitValue();
    }

    private String FileFormat2AvrdudeOption(FileFormat fileFormat) {
        switch (fileFormat) {
            case RAW: {
                return "r";
            }
            case INTEL_HEX: {
                return "i";
            }
            case MOTOROLA_S_RECORD: {
                return "s";
            }
            case AUTO_DETECT: {
                return "a";
            }
        }
        assert (false);
        return "";
    }

    public static FileFormat String2FileFormat(String fileFormat) {
        if (fileFormat.equals("Intel Hex")) {
            return FileFormat.INTEL_HEX;
        }
        if (fileFormat.equals("Motorola S-record")) {
            return FileFormat.MOTOROLA_S_RECORD;
        }
        if (fileFormat.equals("raw")) {
            return FileFormat.RAW;
        }
        return FileFormat.AUTO_DETECT;
    }

    public Boolean getDisableAutoErase() {
        return this.m_disableAutoErase;
    }

    public void setDisableAutoErase(Boolean disableAutoErase) {
        this.m_disableAutoErase = disableAutoErase;
    }

    public Boolean getExitSpecActivated() {
        return this.m_exitSpecActivated;
    }

    public void setExitSpecActivated(Boolean exitSpecActivated) {
        this.m_exitSpecActivated = exitSpecActivated;
    }

    public Boolean getLeftResetActivated() {
        return this.m_leftResetActivated;
    }

    public void setLeftResetActivated(Boolean leftResetActivated) {
        this.m_leftResetActivated = leftResetActivated;
    }

    public Boolean getLeftVccActivated() {
        return this.m_leftVccActivated;
    }

    public void setLeftVccActivated(Boolean leftVccActivated) {
        this.m_leftVccActivated = leftVccActivated;
    }

    public Boolean getDisableFuseCheck() {
        return this.m_disableFuseCheck;
    }

    public void setDisableFuseCheck(Boolean disableFuseCheck) {
        this.m_disableFuseCheck = disableFuseCheck;
    }

    public static enum FileFormat {
        RAW,
        INTEL_HEX,
        MOTOROLA_S_RECORD,
        AUTO_DETECT;

    }
}

