/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool;

import avr8_burn_o_mat.AVR;
import avr8_burn_o_mat.AvrdudeConfigFile;
import avr8_burn_o_mat.AvrdudeControl;
import avr8_burn_o_mat.AvrdudeProgrammer;
import avr8_burn_o_mat.InterfaceTextOutput;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.gui.ColorTweaks;
import de.lazyzero.kkMulticopterFlashTool.gui.ControllerPanel;
import de.lazyzero.kkMulticopterFlashTool.gui.EEpromResetPanel;
import de.lazyzero.kkMulticopterFlashTool.gui.EEpromSettingsPanel;
import de.lazyzero.kkMulticopterFlashTool.gui.FirmwarePanel;
import de.lazyzero.kkMulticopterFlashTool.gui.ProgrammerPanel;
import de.lazyzero.kkMulticopterFlashTool.gui.kkMenu;
import de.lazyzero.kkMulticopterFlashTool.utils.ArduinoUpload;
import de.lazyzero.kkMulticopterFlashTool.utils.ButtonsStateListener;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEprom;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromListener;
import de.lazyzero.kkMulticopterFlashTool.utils.FileCorruptException;
import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import de.lazyzero.kkMulticopterFlashTool.utils.Icons;
import de.lazyzero.kkMulticopterFlashTool.utils.XmlReaderFirmwares;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SplashScreen;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class KKMulticopterFlashTool
extends JFrame
implements InterfaceTextOutput,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static String VERSION = "0.77";
    private static boolean isBeta = false;
    private static int betaVersion = 1;
    public static final String MODE_CHANGED = "changed";
    public static final String KKPLUSBOOT = "kkplusboot";
    public static final String FLYCAM_BLACKBOARD = "flycam_black";
    public static final String FLYCAM_BLACKBOARD_P = "flycam_blackp";
    public static final String SMARTLCD = "smartlcd";
    public static final String ESC = "esc";
    public static final String ESCBOOTLOADER = "escp";
    public static final String WIIESC = "wii_bl";
    public static final String WIIESC_EEPROM = "wii_eeprom";
    public static final Object WIIESC_BOOTLOADER = "wii_boot";
    public static final String ESC_LIGHT = "esc_light";
    public static final String OPENFLIGHT_V1 = "openflightV1";
    public static final String OPENFLIGHT_V2 = "openflightV2";
    public static final String OPENFLIGHT_V2_SM = "openflightSM";
    public static final String OPENFLIGHTPROG = "openflightPROG";
    public static final String i86 = "i86";
    public static final String i86l = "i86l";
    private static KKMulticopterFlashTool kk;
    private Locale locale;
    private JPanel mainPanel;
    private Properties settings = new Properties();
    public static File SETTINGS_FILE;
    public static File LOG_FILE;
    private JFrame mainframe;
    private Dimension preferredSize = new Dimension(830, 650);
    private AvrdudeConfigFile avrConfig;
    private AvrdudeProgrammer programmer;
    private AvrdudeControl control;
    private boolean forceFlashing = false;
    private Vector<AvrdudeProgrammer> programmers;
    private static Vector<AVR> avrs;
    private AVR controller;
    private JTextArea output;
    private Color defaultFG;
    private JScrollPane outputPane;
    private ProgrammerPanel programmerPanel;
    private ControllerPanel controllerPanel;
    private FirmwarePanel firmwarePanel;
    private LinkedHashMap<String, String> firmwareRepositoryURL = new LinkedHashMap();
    private Firmware firmware;
    private XmlReaderFirmwares firmwareReader;
    private boolean offlineMode;
    private String mode;
    private FileHandler logFile;
    private Logger logger = Logger.getLogger(KKMulticopterFlashTool.class.getName());
    private boolean enableTweak = true;
    public static boolean ENABLE_PORT_CHECK;
    private static boolean isPopupsEnabled;
    private static int countdown;
    private static boolean isHideDeprecated;
    private static boolean isShowDailyTGYEnabled;
    private static boolean isVerbose;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel programmingPanel;
    private JPanel eepromPanel;
    private Component eepromResetPanel;
    private EEpromSettingsPanel eepromSettingsPanel;
    protected boolean successful;
    private Vector<ButtonsStateListener> listeners = new Vector();
    private boolean isNoLogging = false;
    private boolean useDefaults = false;

    static {
        SETTINGS_FILE = new File(System.getProperty("user.dir"), "kkMulticopterFlashTool.properties");
        LOG_FILE = new File(System.getProperty("user.dir"), "kkLogging.txt");
        avrs = new Vector();
        ENABLE_PORT_CHECK = true;
    }

    public KKMulticopterFlashTool(String[] args) {
        SplashScreen splash;
        kk = this;
        this.evaluateCommandlineOptions(args);
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            SETTINGS_FILE = new File(String.valueOf(System.getProperty("user.home")) + "/Library/Preferences/", "kkMulticopterFlashTool.properties");
            LOG_FILE = new File(KKMulticopterFlashTool.getTempFolder(), "kkLogging.txt");
        }
        if (!this.isNoLogging) {
            this.initLogger();
        }
        if ((splash = SplashScreen.getSplashScreen()) == null) {
            this.logger.log(Level.INFO, "Splash not loaded.");
        }
        this.logger.log(Level.INFO, System.getProperty("user.home"));
        this.logger.log(Level.INFO, System.getProperty("os.name"));
        this.loadSettings();
        this.loadTranslation();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                KKMulticopterFlashTool.this.saveSettings();
            }
        });
        this.firmwareReader = new XmlReaderFirmwares(this.firmwareRepositoryURL);
        this.init();
        if (this.enableTweak) {
            ColorTweaks.tweakColors();
        }
        this.initGUI();
        this.addPropertyChangeListener(this);
        this.checkVersion();
    }

    private void evaluateCommandlineOptions(String[] args) {
        Options options = new Options();
        options.addOption("h", "help", false, "Show this help message.");
        options.addOption("c", "color", false, "Use default colors of the Java VM.");
        options.addOption("p", "portcheck", false, "Disable checking for port checking.");
        options.addOption("n", "nologging", false, "Disable logging to file.");
        options.addOption("d", "defaults", false, "Use default settings");
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("KKmulticopter Flash Tool Version " + VERSION, options, true);
                System.exit(0);
            }
            if (cmd.hasOption("c")) {
                this.enableTweak = false;
            }
            if (cmd.hasOption("p")) {
                ENABLE_PORT_CHECK = false;
            }
            if (cmd.hasOption("n")) {
                this.isNoLogging = true;
            }
            if (cmd.hasOption("d")) {
                this.useDefaults = true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void initLogger() {
        try {
            this.logFile = new FileHandler(LOG_FILE.getAbsolutePath(), false);
            this.logFile.setFormatter(new SimpleFormatter());
            this.logFile.setLevel(Level.INFO);
            this.logger.addHandler(this.logFile);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.setLevel(Level.INFO);
    }

    private void checkVersion() {
        this.logger.log(Level.INFO, "Check the version: " + VERSION + (isBeta ? " beta " + betaVersion : "") + " online is version: " + this.firmwareReader.getActualVersion());
        if (this.firmwareReader.getActualVersion() > Double.parseDouble(VERSION)) {
            Object[] choices = new String[]{Translatrix._("downloads.download"), Translatrix._("Cancel")};
            int result = JOptionPane.showOptionDialog(this, Translatrix._("update"), "", 1, 1, null, choices, choices[0]);
            if (result == 0) {
                kkMenu.openURL("http://kkflashtool.de");
                System.exit(0);
            }
        }
    }

    public void flashAVR() {
        boolean abort = this.check4USBlinker();
        if (!abort) {
            new Thread(){

                @Override
                public void run() {
                    boolean notFailed = true;
                    boolean isUSBtiny = KKMulticopterFlashTool.this.programmer.getType().equals("usbtiny");
                    KKMulticopterFlashTool.this.firmwarePanel.setButtonsEnabled(false);
                    KKMulticopterFlashTool.this.updateButtons();
                    try {
                        KKMulticopterFlashTool.this.control = new AvrdudeControl(KKMulticopterFlashTool.this, isUSBtiny);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        KKMulticopterFlashTool.this.logger.log(Level.WARNING, e1.getMessage());
                    }
                    if (isVerbose) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-vvvvv ");
                    }
                    KKMulticopterFlashTool.this.control.setPort(KKMulticopterFlashTool.this.programmerPanel.getPort());
                    KKMulticopterFlashTool.this.control.setProgrammer(KKMulticopterFlashTool.this.programmer);
                    if (KKMulticopterFlashTool.this.programmerPanel.useBaudRate()) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-b " + KKMulticopterFlashTool.this.programmerPanel.getRate());
                    }
                    KKMulticopterFlashTool.this.logger.log(Level.INFO, KKMulticopterFlashTool.this.programmer.getType());
                    KKMulticopterFlashTool.this.control.addAdditionalOption("-e");
                    KKMulticopterFlashTool.this.logger.log(Level.INFO, "set additional Option -e");
                    if (KKMulticopterFlashTool.this.forceFlashing) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-F");
                    }
                    KKMulticopterFlashTool.this.control.setDisableFuseCheck(false);
                    KKMulticopterFlashTool.this.control.addAndUpdateAdditionalOptions(KKMulticopterFlashTool.this.firmware.getAdditionalOptions());
                    if (KKMulticopterFlashTool.this.controller.getLfuse() != null && KKMulticopterFlashTool.this.controller.getHfuse() != null) {
                        try {
                            KKMulticopterFlashTool.this.logger.log(Level.INFO, "write fuses: ");
                            KKMulticopterFlashTool.this.control.writeFuses(KKMulticopterFlashTool.this.controller);
                        }
                        catch (Exception e) {
                            notFailed = false;
                            e.printStackTrace();
                            KKMulticopterFlashTool.this.logger.log(Level.WARNING, "error.writefuses");
                            KKMulticopterFlashTool.this.err(Translatrix._("error.writefuses"));
                        }
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                            KKMulticopterFlashTool.this.logger.log(Level.WARNING, e1.toString());
                        }
                    }
                    if (KKMulticopterFlashTool.this.controller.getCaption().equals(KKMulticopterFlashTool.ESCBOOTLOADER) && notFailed) {
                        KKMulticopterFlashTool.this.logger.log(Level.INFO, "enable bootloader on simonk ESC: " + KKMulticopterFlashTool.this.controller.getBootloaderAddress());
                        try {
                            KKMulticopterFlashTool.this.control.readFuses(KKMulticopterFlashTool.this.controller, KKMulticopterFlashTool.getTempFolder());
                            KKMulticopterFlashTool.this.logger.log(Level.INFO, "hfuse: " + Integer.toHexString(Integer.parseInt(KKMulticopterFlashTool.this.controller.getHfuse())) + " lfuse: " + Integer.toHexString(Integer.parseInt(KKMulticopterFlashTool.this.controller.getLfuse())));
                            if (KKMulticopterFlashTool.this.controller.getBootloaderAddress() == 512) {
                                KKMulticopterFlashTool.this.controller.changeFuseNibble("hfuse", 0, "a");
                                KKMulticopterFlashTool.this.logger.log(Level.INFO, "fuses changed to: hfuse: " + Integer.toHexString(Integer.parseInt(KKMulticopterFlashTool.this.controller.getHfuse())) + " lfuse: " + Integer.toHexString(Integer.parseInt(KKMulticopterFlashTool.this.controller.getLfuse())));
                            }
                            try {
                                Thread.sleep(1500L);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                                KKMulticopterFlashTool.this.logger.log(Level.WARNING, e1.toString());
                            }
                            KKMulticopterFlashTool.this.logger.log(Level.INFO, "write new fuses: ");
                            KKMulticopterFlashTool.this.control.writeFuses(KKMulticopterFlashTool.this.controller);
                        }
                        catch (Exception e) {
                            notFailed = false;
                            KKMulticopterFlashTool.this.err(Translatrix._("error.readhfuse"));
                            KKMulticopterFlashTool.this.logger.log(Level.WARNING, "error.replacefuse");
                            e.printStackTrace();
                        }
                        KKMulticopterFlashTool.this.controller.setHfuse(null);
                        KKMulticopterFlashTool.this.controller.setLfuse(null);
                        File fuseFile = new File(String.valueOf(KKMulticopterFlashTool.getTempFolder()) + "/hfuse.hex");
                        boolean isDeleted = false;
                        if (fuseFile.exists() && fuseFile.isFile()) {
                            isDeleted = fuseFile.delete();
                            KKMulticopterFlashTool.this.logger.log(Level.INFO, "hfuse.hex deleted: " + isDeleted);
                        }
                        if ((fuseFile = new File(String.valueOf(KKMulticopterFlashTool.getTempFolder()) + "/lfuse.hex")).exists() && fuseFile.isFile()) {
                            isDeleted = fuseFile.delete();
                            KKMulticopterFlashTool.this.logger.log(Level.INFO, "lfuse.hex deleted: " + isDeleted);
                        }
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                            KKMulticopterFlashTool.this.logger.log(Level.WARNING, e1.toString());
                        }
                    }
                    try {
                        if (notFailed) {
                            KKMulticopterFlashTool.this.logger.log(Level.INFO, "flash firmware");
                            try {
                                File file = KKMulticopterFlashTool.this.firmware.getFile();
                                KKMulticopterFlashTool.this.println(String.valueOf(Translatrix._("flash.file")) + ": " + file.getAbsolutePath());
                                KKMulticopterFlashTool.this.control.writeFlash(KKMulticopterFlashTool.this.controller, file.getAbsolutePath(), AvrdudeControl.FileFormat.INTEL_HEX);
                                if (isPopupsEnabled) {
                                    JOptionPane.showMessageDialog(kk, Translatrix._("flash.successfull"), Translatrix._("info"), 1);
                                }
                                KKMulticopterFlashTool.this.println(Translatrix._("flash.successfull"));
                            }
                            catch (FileCorruptException e) {
                                KKMulticopterFlashTool.this.err(String.valueOf(Translatrix._("flash.abort")) + " " + Translatrix._("flash.filecorrupt"));
                            }
                        } else {
                            KKMulticopterFlashTool.this.err(Translatrix._("flash.abort"));
                            KKMulticopterFlashTool.this.logger.log(Level.WARNING, "flash.abort");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        KKMulticopterFlashTool.this.err(Translatrix._("error.writeflash"));
                        KKMulticopterFlashTool.this.logger.log(Level.WARNING, "error.writeflash");
                    }
                    KKMulticopterFlashTool.this.firmwarePanel.setButtonsEnabled(true);
                    KKMulticopterFlashTool.this.updateButtons();
                }
            }.start();
        } else {
            this.err(Translatrix._("flash.abort"));
        }
    }

    public void flashEEprom(final EEpromListener eepromListener) {
        this.logger.info("WRITE the EEprom!!!");
        this.clearText();
        boolean abort = this.check4USBlinker();
        if (!abort) {
            new Thread(){

                @Override
                public void run() {
                    boolean isUSBtiny = KKMulticopterFlashTool.this.programmer.getType().equals("usbtiny");
                    try {
                        KKMulticopterFlashTool.this.control = new AvrdudeControl(KKMulticopterFlashTool.this, isUSBtiny);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        KKMulticopterFlashTool.this.logger.log(Level.WARNING, e1.getMessage());
                    }
                    if (isVerbose) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-vvvvv ");
                    }
                    KKMulticopterFlashTool.this.control.setPort(KKMulticopterFlashTool.this.programmerPanel.getPort());
                    KKMulticopterFlashTool.this.control.setProgrammer(KKMulticopterFlashTool.this.programmer);
                    if (KKMulticopterFlashTool.this.programmerPanel.useBaudRate()) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-b " + KKMulticopterFlashTool.this.programmerPanel.getRate());
                    }
                    KKMulticopterFlashTool.this.logger.log(Level.INFO, KKMulticopterFlashTool.this.programmer.getType());
                    if (KKMulticopterFlashTool.this.forceFlashing) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-F");
                    }
                    KKMulticopterFlashTool.this.control.setDisableFuseCheck(false);
                    KKMulticopterFlashTool.this.logger.log(Level.INFO, "flash eeprom");
                    try {
                        if (KKMulticopterFlashTool.this.controller.getCaption().equals(KKMulticopterFlashTool.WIIESC_EEPROM)) {
                            File file = KKMulticopterFlashTool.this.firmware.getFile();
                            KKMulticopterFlashTool.this.println(String.valueOf(Translatrix._("flash.eeprom")) + ": " + file.getAbsolutePath());
                            KKMulticopterFlashTool.this.control.writeEEPROM(KKMulticopterFlashTool.this.controller, file.getAbsolutePath(), AvrdudeControl.FileFormat.AUTO_DETECT);
                        } else {
                            KKMulticopterFlashTool.this.println(String.valueOf(Translatrix._("flash.eeprom")) + ": " + EEprom.getDefaultOutputFile());
                            KKMulticopterFlashTool.this.control.writeEEPROM(KKMulticopterFlashTool.this.controller, EEprom.getDefaultOutputFile(), AvrdudeControl.FileFormat.RAW);
                            eepromListener.EEpromState(1);
                        }
                    }
                    catch (FileCorruptException e) {
                        KKMulticopterFlashTool.this.err(String.valueOf(Translatrix._("flash.abort")) + " " + Translatrix._("flash.filecorrupt"));
                        eepromListener.EEpromState(-2);
                    }
                    catch (Exception e) {
                        if (eepromListener != null) {
                            eepromListener.EEpromState(-3);
                        }
                        KKMulticopterFlashTool.this.err(Translatrix._("flash.abort"));
                        KKMulticopterFlashTool.this.logger.warning(e.getMessage());
                    }
                }
            }.start();
        } else {
            this.err(Translatrix._("flash.abort"));
        }
    }

    public void readEEprom(final EEpromListener eepromListener) {
        this.logger.info("READ the EEprom!!!");
        this.clearText();
        boolean abort = this.check4USBlinker();
        if (!abort) {
            new Thread(){

                @Override
                public void run() {
                    boolean isUSBtiny = KKMulticopterFlashTool.this.programmer.getType().equals("usbtiny");
                    try {
                        KKMulticopterFlashTool.this.control = new AvrdudeControl(KKMulticopterFlashTool.this, isUSBtiny);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        KKMulticopterFlashTool.this.logger.log(Level.WARNING, e1.getMessage());
                    }
                    KKMulticopterFlashTool.this.control.setPort(KKMulticopterFlashTool.this.programmerPanel.getPort());
                    KKMulticopterFlashTool.this.control.setProgrammer(KKMulticopterFlashTool.this.programmer);
                    if (KKMulticopterFlashTool.this.programmerPanel.useBaudRate()) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-b " + KKMulticopterFlashTool.this.programmerPanel.getRate());
                    }
                    KKMulticopterFlashTool.this.logger.log(Level.INFO, KKMulticopterFlashTool.this.programmer.getType());
                    if (!KKMulticopterFlashTool.this.programmer.getType().equals("usbtiny")) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-B 8");
                        KKMulticopterFlashTool.this.logger.log(Level.INFO, "set additional Option -B 8");
                    }
                    if (KKMulticopterFlashTool.this.forceFlashing) {
                        KKMulticopterFlashTool.this.control.addAdditionalOption("-F");
                    }
                    KKMulticopterFlashTool.this.control.setDisableFuseCheck(false);
                    KKMulticopterFlashTool.this.logger.log(Level.INFO, "flash eeprom");
                    try {
                        KKMulticopterFlashTool.this.println(String.valueOf(Translatrix._("read.eeprom")) + ": " + EEprom.getDefaultInputFile());
                        KKMulticopterFlashTool.this.control.readEEPROM(KKMulticopterFlashTool.this.controller, EEprom.getDefaultInputFile(), AvrdudeControl.FileFormat.RAW);
                        eepromListener.EEpromState(0);
                    }
                    catch (Exception e) {
                        eepromListener.EEpromState(-1);
                        KKMulticopterFlashTool.this.err(Translatrix._("read.abort"));
                        KKMulticopterFlashTool.this.logger.warning(e.getMessage());
                    }
                }
            }.start();
        } else {
            eepromListener.EEpromState(-1);
            this.err(Translatrix._("read.abort"));
        }
    }

    private boolean check4USBlinker() {
        if ((this.programmer.getId().equals("tgyusblinker") || this.programmer.getId().equals("arduinousblinker") || this.programmer.getId().equals("afrousb")) && this.programmerPanel.getPort().equals("usb")) {
            this.err(Translatrix._("flash.LinkerWrongPort"));
            return true;
        }
        return false;
    }

    public void loadSettings() {
        try {
            this.settings.load(new FileInputStream(SETTINGS_FILE));
            this.firmwareRepositoryURL.put("firmwareRepositoryURL", this.settings.getProperty("firmwareRepositoryURL", "http://www.lazyzero.de/_media/firmwares.xml.zip"));
            if (this.firmwareRepositoryURL.containsValue("http://www.lazyzero.de/_media/firmwares.xml")) {
                this.firmwareRepositoryURL.put("firmwareRepositoryURL", "http://www.lazyzero.de/_media/firmwares.xml.zip");
            }
            this.firmwareRepositoryURL.put("tgydaily", this.settings.getProperty("tgydaily", "http://www.lazyzero.de/_media/tgy_daily.xml.zip"));
            this.offlineMode = new Boolean(this.settings.getProperty("offlineMode", "false"));
            isPopupsEnabled = new Boolean(this.settings.getProperty("isPopupEnabled", "true"));
            isHideDeprecated = new Boolean(this.settings.getProperty("isHideDeprecated", "false"));
            isVerbose = new Boolean(this.settings.getProperty("isVerbose", "false"));
            isShowDailyTGYEnabled = new Boolean(this.settings.getProperty("isShowDailyTGYEnabled", "false"));
            countdown = Integer.parseInt(this.settings.getProperty("countdown", "0"));
            this.mode = KKMulticopterFlashTool.isOfflineMode() ? Translatrix._("offline") : Translatrix._("online");
            try {
                this.setLocale(this.settings.getProperty("locale.language", "en"), this.settings.getProperty("locale.country", "US"));
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            this.firmwareRepositoryURL.put("firmwareRepositoryURL", "http://www.lazyzero.de/_media/firmwares.xml.zip");
            this.offlineMode = false;
            this.saveSettings();
            e.printStackTrace();
        }
    }

    private void saveSettings() {
        if (!this.useDefaults) {
            try {
                this.settings.put("locale.language", this.locale.getLanguage());
                this.settings.put("locale.country", this.locale.getCountry());
                this.settings.put("offlineMode", String.valueOf(this.offlineMode));
                this.settings.put("isPopupEnabled", String.valueOf(isPopupsEnabled));
                this.settings.put("isHideDeprecated", String.valueOf(isHideDeprecated));
                this.settings.put("isVerbose", String.valueOf(isVerbose));
                this.settings.put("isShowDailyTGYEnabled", String.valueOf(isShowDailyTGYEnabled));
                this.settings.put("countdown", String.valueOf(countdown));
                this.settings.put("programmer", this.programmer.getId());
                this.settings.put("port", this.programmerPanel.getPort());
                this.settings.put("rate", this.programmerPanel.getRate());
                this.settings.put("defaultRate", String.valueOf(this.programmerPanel.isDefaultRate()));
                this.settings.put("controller", this.controller.getName());
                for (String key : this.firmwareRepositoryURL.keySet()) {
                    this.settings.put(key, this.firmwareRepositoryURL.get(key));
                }
                try {
                    this.settings.put("last.dir", this.firmware.getFile().getPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.settings.store(new FileOutputStream(SETTINGS_FILE), "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void init() {
        this.avrConfig = new AvrdudeConfigFile();
        try {
            this.avrConfig.readAvrdudeConfigFile(AvrdudeConfigFile.getConfigFileByOS());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, Translatrix._("error.avrdudeconfig"));
            e.printStackTrace();
        }
        this.programmers = this.avrConfig.getProgrammerList();
        avrs.add(new AVR("HobbyKing KK2.1 and KK2.1.5", "64kB flash", "m644p", 2048, null, null));
        avrs.add(new AVR("HobbyKing KK2.1 and KK2.1.5 (fuse restore)", "64kB flash", "m644p", 2048, "0xf7", "0xd7", "0xfc"));
        avrs.add(new AVR("HobbyKing KK2.0", "32kB flash", "m324pa", 1024, null, null));
        avrs.add(new AVR("HobbyKing KK2.0 (fuse restore)", "32kB flash", "m324pa", 1024, "0xf7", "0xd7", "0xfc"));
        avrs.add(new AVR("HobbyKing KK2.0 (brown out of 2.7V)", "32kB flash", "m324pa", 1024, "0xf7", "0xd7", "0xfd"));
        avrs.add(new AVR("HobbyKing KK2.0 (ATmega1284P)", "128kB flash", "m1284p", 4096, "0xd7", "0xd1", "0xfc"));
        avrs.add(new AVR("atmega 8-based brushless ESC", "8kB flash", ESC, 512, null, null));
        avrs.add(new AVR("atmega 8-based brushless ESC + enable Bootloader", "8kB flash", ESCBOOTLOADER, 512, null, null, 512));
        avrs.add(new AVR("atmega 8-based brushless ESC (fuse restore, external clock", "8kB flash", ESCBOOTLOADER, 512, "0x3f", "0xca"));
        avrs.add(new AVR("atmega 8-based brushless ESC (fuse restore, internal clock", "8kB flash", ESCBOOTLOADER, 512, "0x24", "0xda"));
        avrs.add(new AVR("WiiESC", "8kB flash", WIIESC, 512, null, null));
        avrs.add(new AVR("WiiESC Settings", "8kB flash", WIIESC_EEPROM, 512, null, null));
        avrs.add(new AVR("EscLight", "8kB flash", ESC_LIGHT, 512, null, null));
        avrs.add(new AVR("Orange RX3S V2/V3", "16kB flash", OPENFLIGHT_V2, 512, null, null));
        avrs.add(new AVR("Orange RX3SM", "16kB flash", OPENFLIGHT_V2_SM, 512, null, null));
        avrs.add(new AVR("Orange RX3S V1", "16kB flash", OPENFLIGHT_V1, 512, null, null));
        avrs.add(new AVR("OpenFlight Programming Box", "8kB flash", OPENFLIGHTPROG, 512, null, null));
        avrs.add(new AVR("KK Blackboard 168", "16kB flash", "m168", 512, "0xe2", "0xdd"));
        avrs.add(new AVR("KK Blackboard 168P/PA", "16kB flash", "m168p", 512, "0xe2", "0xdd"));
        avrs.add(new AVR("KK Blackboard 328P", "32kB flash", "m328p", 1024, "0xe2", "0xd9"));
        avrs.add(new AVR("KK Plus 5.5d/e", "16kB flash", "m168p", 512, "0xe2", "0xde"));
        avrs.add(new AVR("HobbyKing Quadcopter Control Board V3", "32kB flash", "m328p", 1024, "0xe2", "0xd9"));
        avrs.add(new AVR("HobbyKing Quadcopter Control Board V2/V2.1", "16kB flash", "m168p", 512, "0xe2", "0xdd"));
        avrs.add(new AVR("HobbyKing Quadcopter Control Board V1", "4kB flash", "m48p", 256, "0xe2", "0xdd"));
        avrs.add(new AVR("HobbyKing Hobbyking i86 or Eagle N6 V1", "16kB flash", i86, 512, "0xe2", "0xdd"));
        avrs.add(new AVR("HobbyKing Hobbyking i86L or Eagle N6 V2", "16kB flash", i86l, 512, null, null));
        avrs.add(new AVR("Flycam Blackboard", "16kB flash", FLYCAM_BLACKBOARD, 512, "0xe2", "0xdd"));
        avrs.add(new AVR("Flycam Blackboard (Goodluckbuy version)", "16kB flash", FLYCAM_BLACKBOARD_P, 512, "0xe2", "0xdd"));
        avrs.add(new AVR("Korean Blueboard", "16kB flash", "m168", 512, "0xe2", "0xdd"));
        avrs.add(new AVR("Korean Redboard (without chip update)", "4kB flash", "m48", 256, "0xe2", "0xdd"));
        avrs.add(new AVR("SmartLCD Pro", "4kB flash", SMARTLCD, 256, null, null));
    }

    private void initGUI() {
        this.mainPanel = new JPanel();
        CellConstraints cc = new CellConstraints();
        String panelColumns = "fill:pref:grow";
        String panelRows = "3dlu,pref,3dlu,pref,3dlu,pref:grow";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.mainPanel.setLayout((LayoutManager)panelLayout);
        this.programmingPanel = this.ceateProgrammingPanel();
        this.eepromPanel = this.createEEpromPanel();
        this.tabbedPane.add(this.programmingPanel);
        this.programmerPanel = new ProgrammerPanel(this, this.programmers);
        this.controllerPanel = new ControllerPanel(this, avrs);
        this.mainPanel.add((Component)this.programmerPanel, cc.xy(1, 2));
        this.mainPanel.add((Component)this.controllerPanel, cc.xy(1, 4));
        this.mainPanel.add((Component)this.tabbedPane, cc.xy(1, 6));
        this.logger.log(Level.INFO, "Set the port from the properties [usb]: " + this.settings.getProperty("port", "usb"));
        this.programmerPanel.setPort(this.settings.getProperty("port", "usb"));
        this.programmerPanel.setRate(this.settings.getProperty("rate", "19200"));
        this.programmerPanel.setDefaultRate(new Boolean(this.settings.getProperty("defaultRate", "true")));
        this.programmerPanel.setProgrammer(this.settings.getProperty("programmer", "usbasp"));
        this.controllerPanel.setController(this.settings.getProperty("controller", "Blackboard"));
        this.tabbedPane.addTab(Translatrix._("programmingPanel.title"), this.programmingPanel);
        this.tabbedPane.setBorder(new LineBorder(Color.WHITE));
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(Translatrix._("eepromPanel.title"), this.eepromPanel);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JTabbedPane sourceTabbedPane = (JTabbedPane)event.getSource();
                if (sourceTabbedPane.getSelectedComponent().equals(KKMulticopterFlashTool.this.eepromPanel)) {
                    KKMulticopterFlashTool.this.logger.info("changed to eepromPanel");
                    KKMulticopterFlashTool.this.eepromResetPanel.firePropertyChange("controllerChanged", 0L, 1L);
                } else if (sourceTabbedPane.getSelectedComponent().equals(KKMulticopterFlashTool.this.programmingPanel)) {
                    KKMulticopterFlashTool.this.logger.info("changed to programmingPanel");
                }
            }
        });
        this.mainframe = new JFrame(String.valueOf(Translatrix._("title")) + " " + VERSION + (isBeta ? " beta " + betaVersion : "") + " - " + this.mode);
        this.mainframe.add(this.mainPanel);
        this.mainframe.setJMenuBar(new kkMenu(this, this.firmwareReader).getBar());
        this.mainframe.setIconImage(Icons.getImage("KK.png", 16));
        this.mainframe.pack();
        this.mainframe.setLocationRelativeTo(this.getRootPane());
        this.mainframe.setDefaultCloseOperation(3);
        this.firmwarePanel.firePropertyChange("controllerChanged", 0, 1);
    }

    private JPanel createEEpromPanel() {
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        String panelColumns = "pref:grow";
        String panelRows = "pref,3dlu,fill:pref:grow,3dlu,pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        panel.setLayout((LayoutManager)panelLayout);
        this.eepromResetPanel = new EEpromResetPanel(this);
        this.eepromSettingsPanel = new EEpromSettingsPanel(this);
        panel.add(this.eepromResetPanel, cc.xy(1, 1));
        panel.add((Component)this.eepromSettingsPanel, cc.xy(1, 3));
        return panel;
    }

    private JPanel ceateProgrammingPanel() {
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        String panelColumns = "pref:grow";
        String panelRows = "pref,3dlu,fill:pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        panel.setLayout((LayoutManager)panelLayout);
        this.firmwarePanel = new FirmwarePanel(this, this.firmwareReader);
        this.addButtonsStateListener(this.firmwarePanel);
        this.output = new JTextArea();
        this.output.setColumns(20);
        this.output.setEditable(false);
        this.output.setRows(15);
        this.defaultFG = this.output.getForeground();
        this.outputPane = new JScrollPane(this.output);
        this.outputPane.setAutoscrolls(true);
        this.outputPane.setVerticalScrollBarPolicy(22);
        panel.add((Component)this.firmwarePanel, cc.xy(1, 1));
        panel.add((Component)this.outputPane, cc.xy(1, 3));
        return panel;
    }

    public void setLocale(String language, String country) {
        this.locale = new Locale(language, country);
        this.logger.log(Level.INFO, String.valueOf(language) + "_" + country);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    private void loadTranslation() {
        Translatrix.loadSupportedLocales("de.lazyzero.kkMulticopterFlashTool.gui.resources.supportedLocales");
        Translatrix.setLocale(Translatrix.getDefaultLocale());
        Vector<Locale> locales = new Vector<Locale>(Translatrix.getSupportedLocales());
        if (locales.contains(this.locale)) {
            Translatrix.setLocale(this.locale);
        } else {
            this.locale = Translatrix.getLocale();
        }
        Translatrix.addBundle("de.lazyzero.kkMulticopterFlashTool.gui.resources.translatrix");
    }

    public boolean restart() {
        int response = JOptionPane.showConfirmDialog(this.mainframe, Translatrix._("restart.dialog"), Translatrix._("restart.title"), 0);
        return response == 0;
    }

    public JFrame getMainframe() {
        return this.mainframe;
    }

    public Properties getSettings() {
        return this.settings;
    }

    public static void main(String[] args) {
        new KKMulticopterFlashTool(args);
        KKMulticopterFlashTool.kk.mainframe.setVisible(true);
    }

    @Override
    public void print(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KKMulticopterFlashTool.this.output.append(line);
            }
        });
    }

    @Override
    public void println(final String line) {
        this.logger.log(Level.INFO, line);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KKMulticopterFlashTool.this.output.append(line);
                KKMulticopterFlashTool.this.output.append("\n");
            }
        });
    }

    @Override
    public void err(final String line) {
        this.logger.log(Level.WARNING, line);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KKMulticopterFlashTool.this.output.setForeground(Color.red);
                KKMulticopterFlashTool.this.output.append(line);
                KKMulticopterFlashTool.this.output.append("\n");
            }
        });
        if (isPopupsEnabled) {
            JOptionPane.showMessageDialog(this, line, Translatrix._("error"), 0);
        }
    }

    @Override
    public void clearText() {
        this.output.setForeground(this.defaultFG);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KKMulticopterFlashTool.this.output.setText("");
            }
        });
    }

    @Override
    public String getText() {
        return this.output.getText();
    }

    public AvrdudeProgrammer getProgrammer() {
        return this.programmer;
    }

    public void setProgrammer(AvrdudeProgrammer programmer) {
        this.programmer = programmer;
    }

    public AVR getController() {
        return this.controller;
    }

    public void setController(AVR controller) {
        this.controller = controller;
    }

    public void setFirmware(Firmware firmware) {
        this.firmware = firmware;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("controllerChanged")) {
            this.firmwarePanel.firePropertyChange("controllerChanged", 0, 1);
            this.eepromResetPanel.firePropertyChange("controllerChanged", 0L, 1L);
        }
        if (evt.getPropertyName().equals(MODE_CHANGED)) {
            this.firmwarePanel.firePropertyChange("controllerChanged", 0, 1);
            this.mode = KKMulticopterFlashTool.isOfflineMode() ? Translatrix._("offline") : Translatrix._("online");
            this.mainframe.setTitle(String.valueOf(Translatrix._("title")) + " " + VERSION + " - " + this.mode);
        }
        evt.getPropertyName().equals("PROGRAMMER_CHANGED");
    }

    public static String getTempFolder() {
        String tmpdir = System.getProperty("os.name").toLowerCase().contains("windows") ? String.valueOf(System.getProperty("user.dir")) + "\\tmp\\" : (System.getProperty("os.name").toLowerCase().contains("mac") ? String.valueOf(System.getProperty("user.home")) + "/Library/Preferences/kkMulticopterFlashTool/" : String.valueOf(System.getProperty("user.dir")) + "/tmp/");
        KKMulticopterFlashTool.getLogger().log(Level.INFO, tmpdir);
        return tmpdir;
    }

    public static boolean isOfflineMode() {
        try {
            return KKMulticopterFlashTool.kk.offlineMode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setOfflineMode(boolean b) {
        KKMulticopterFlashTool.kk.offlineMode = b;
    }

    public Vector<Firmware> getFirmwares() {
        return this.firmwareReader.getFirmwares();
    }

    public boolean isForceFlashing() {
        return this.forceFlashing;
    }

    public void setForceFlashing(boolean forceFlashing) {
        this.forceFlashing = forceFlashing;
    }

    public static Logger getLogger() {
        try {
            return KKMulticopterFlashTool.kk.logger;
        }
        catch (Exception e) {
            return Logger.getLogger("Default-Logger");
        }
    }

    public static Vector<AVR> getControllers() {
        return avrs;
    }

    public void setSelectedTabIndex(int i) {
        this.tabbedPane.setSelectedIndex(i);
    }

    public static KKMulticopterFlashTool getInstance() {
        return kk;
    }

    public static void setPopupEnabled(boolean enablePopups) {
        isPopupsEnabled = enablePopups;
    }

    public static boolean isPopupsEnabled() {
        return isPopupsEnabled;
    }

    public static void setHideDeprecatedEnabled(boolean hideDeprecated) {
        isHideDeprecated = hideDeprecated;
    }

    public static boolean isHideDecprecatedEnabled() {
        return isHideDeprecated;
    }

    public static void setVerboseEnabled(boolean verbose) {
        isVerbose = verbose;
    }

    public static boolean isVerboseEnabled() {
        return isVerbose;
    }

    public static void setShowDailyTGYEnabled(boolean showDailyTGYEnabled) {
        isShowDailyTGYEnabled = showDailyTGYEnabled;
    }

    public static boolean isShowDailyTGYEnabled() {
        return isShowDailyTGYEnabled;
    }

    public static int getCountdown() {
        System.out.println("Countdown is " + countdown);
        return countdown;
    }

    public static void setCountdown(int value) {
        countdown = value;
    }

    public void addButtonsStateListener(ButtonsStateListener myListener) {
        this.listeners.add(myListener);
    }

    private void updateButtons() {
        for (ButtonsStateListener listener : this.listeners) {
            listener.updateButtons();
        }
    }

    public void flashArduino(ArduinoUpload arduinoUpload, Firmware arduinoFirmware, String arduinoPort) {
        this.programmerPanel.setProgrammer(arduinoUpload.getAvrProgrammer().getId());
        this.programmerPanel.setPort(arduinoPort);
        this.programmerPanel.setRate(String.valueOf(arduinoUpload.getSpeed()));
        this.programmerPanel.setDefaultRate(false);
        this.setController(arduinoUpload.getAVR());
        this.setFirmware(arduinoFirmware);
        this.flashAVR();
        this.firePropertyChange("controllerChanged", false, false);
    }
}

