/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import avr8_burn_o_mat.AVR;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import de.lazyzero.kkMulticopterFlashTool.utils.FirmwareCommit;
import de.lazyzero.kkMulticopterFlashTool.utils.XMLwriter;
import de.lazyzero.kkMulticopterFlashTool.utils.XmlReaderFirmwares;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import lu.tudor.santec.i18n.Translatrix;

public class FirmwareCommitForm
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Dimension dimension = new Dimension(640, 540);
    private CellConstraints cc;
    private JLabel typeLabel;
    private XmlReaderFirmwares firmwareLoader;
    private Vector<String> types = new Vector();
    private JComboBox firmwareTypesCombobox;
    private JLabel versionLabel;
    private JTextField versionField;
    private JLabel authorLabel;
    private JTextField authorField;
    private JLabel controllerLabel;
    private JComboBox controllerCombobox;
    private Vector<AVR> avrs;
    private JLabel fileComment;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JLabel zipFileComment;
    private JLabel zipFileNameLabel;
    private JTextField zipFileNameField;
    private JTextArea comment;
    private JScrollPane commentPane;
    private Component commentLabel;
    private JLabel commentURLlabel;
    private JTextField commentURLField;
    private JLabel commentURLcomment;
    private JButton submitButton;
    private JButton cancelButton;

    public FirmwareCommitForm(XmlReaderFirmwares firmwareLoader) {
        this.firmwareLoader = firmwareLoader;
        this.init();
        this.initGUI();
        this.setVisible(true);
    }

    private void init() {
        this.avrs = new Vector();
        this.avrs.add(new AVR("ATmega48/P/PA", "m48"));
        this.avrs.add(new AVR("ATmega88/P", "m88"));
        this.avrs.add(new AVR("ATmega168/P/PA", "m168"));
        this.avrs.add(new AVR("ATmega328P", "m328p"));
    }

    private void initGUI() {
        JPanel panel = new JPanel();
        this.cc = new CellConstraints();
        String panelColumns = "3dlu,pref,3dlu,pref,3dlu,pref,3dlu,fill:pref:grow,3dlu,pref,3dlu,pref,3dlu";
        String panelRows = "3dlu,pref,3dlu,pref,3dlu,pref,6dlu,pref,3dlu,pref,6dlu,pref,6dlu,pref,3dlu,pref,3dlu,pref,6dlu,pref,3dlu,fill:pref,3dlu,pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        panel.setLayout((LayoutManager)panelLayout);
        this.typeLabel = new JLabel(Translatrix._("FirmwareCommitForm.typeLabel"));
        this.types.add(Translatrix._("FirmwareCommitForm.selectType"));
        this.types.addAll(Firmware.getCategories(this.firmwareLoader.getFirmwares()));
        this.firmwareTypesCombobox = new JComboBox<String>(this.types);
        this.firmwareTypesCombobox.setSelectedIndex(0);
        this.firmwareTypesCombobox.addActionListener(this);
        this.firmwareTypesCombobox.setEditable(true);
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            this.firmwareTypesCombobox.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer df = new DefaultListCellRenderer();
                    JLabel r = (JLabel)df.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    r.setBackground(Color.LIGHT_GRAY);
                    return r;
                }
            });
        }
        this.versionLabel = new JLabel(Translatrix._("FirmwareCommitForm.versionLabel"));
        this.versionField = new JTextField();
        this.versionField.setColumns(4);
        this.controllerLabel = new JLabel(Translatrix._("FirmwareCommitForm.controllerLabel"));
        this.controllerCombobox = new JComboBox<AVR>(this.avrs);
        this.controllerCombobox.setSelectedIndex(0);
        this.authorLabel = new JLabel(Translatrix._("FirmwareCommitForm.authorLabel"));
        this.authorField = new JTextField();
        this.authorField.setColumns(14);
        this.fileComment = new JLabel(Translatrix._("FirmwareCommitForm.fileComment"));
        this.fileNameLabel = new JLabel(Translatrix._("FirmwareCommitForm.fileNameLabel"));
        this.fileNameField = new JTextField();
        this.fileNameField.setColumns(14);
        this.zipFileComment = new JLabel(Translatrix._("FirmwareCommitForm.zipFileComment"));
        this.zipFileNameLabel = new JLabel(Translatrix._("FirmwareCommitForm.zipFileNameLabel"));
        this.zipFileNameField = new JTextField();
        this.zipFileNameField.setColumns(14);
        this.commentURLcomment = new JLabel(Translatrix._("FirmwareCommitForm.commentURLcomment"));
        this.commentURLlabel = new JLabel(Translatrix._("FirmwareCommitForm.commentURLlabel"));
        this.commentURLField = new JTextField();
        this.commentURLField.setColumns(14);
        this.commentLabel = new JLabel(Translatrix._("FirmwareCommitForm.commentLabel"));
        this.comment = new JTextArea();
        this.comment.setColumns(20);
        this.comment.setEditable(true);
        this.comment.setRows(11);
        this.commentPane = new JScrollPane(this.comment);
        this.commentPane.setAutoscrolls(true);
        this.commentPane.setVerticalScrollBarPolicy(22);
        this.submitButton = new JButton(Translatrix._("FirmwareCommitForm.submitButton"));
        this.submitButton.addActionListener(this);
        this.cancelButton = new JButton(Translatrix._("FirmwareCommitForm.cancelButton"));
        this.cancelButton.addActionListener(this);
        this.add(panel);
        panel.add((Component)this.typeLabel, this.cc.xy(2, 2));
        panel.add((Component)this.firmwareTypesCombobox, this.cc.xyw(4, 2, 9));
        panel.add((Component)this.versionLabel, this.cc.xy(2, 4));
        panel.add((Component)this.versionField, this.cc.xy(4, 4));
        panel.add((Component)this.controllerLabel, this.cc.xy(6, 4));
        panel.add((Component)this.controllerCombobox, this.cc.xyw(8, 4, 5));
        panel.add((Component)this.authorLabel, this.cc.xy(2, 6));
        panel.add((Component)this.authorField, this.cc.xyw(4, 6, 9));
        panel.add((Component)this.fileComment, this.cc.xyw(2, 8, 11));
        panel.add((Component)this.fileNameLabel, this.cc.xy(2, 10));
        panel.add((Component)this.fileNameField, this.cc.xyw(4, 10, 9));
        panel.add((Component)this.zipFileComment, this.cc.xyw(2, 12, 11));
        panel.add((Component)this.zipFileNameLabel, this.cc.xy(2, 14));
        panel.add((Component)this.zipFileNameField, this.cc.xyw(4, 14, 9));
        panel.add((Component)this.commentURLcomment, this.cc.xyw(2, 16, 11));
        panel.add((Component)this.commentURLlabel, this.cc.xy(2, 18));
        panel.add((Component)this.commentURLField, this.cc.xyw(4, 18, 9));
        panel.add(this.commentLabel, this.cc.xyw(2, 20, 11));
        panel.add((Component)this.commentPane, this.cc.xyw(2, 22, 11));
        panel.add((Component)this.submitButton, this.cc.xy(10, 24));
        panel.add((Component)this.cancelButton, this.cc.xy(12, 24));
        this.setTitle(Translatrix._("FirmwareCommitForm.title"));
        this.add(panel);
        this.setPreferredSize(this.dimension);
        this.setLocationRelativeTo(KKMulticopterFlashTool.getFrames()[0]);
        this.pack();
    }

    public void sendMail() {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.cancelButton)) {
            this.dispose();
        } else if (event.getSource().equals(this.submitButton)) {
            FirmwareCommit fc = new FirmwareCommit((String)this.firmwareTypesCombobox.getSelectedItem(), this.versionField.getText(), (AVR)this.controllerCombobox.getSelectedItem(), this.authorField.getText(), this.fileNameField.getText(), this.zipFileNameField.getText(), this.commentURLField.getText(), this.comment.getText());
            XMLwriter xml = new XMLwriter(fc);
            xml.sendByEmail();
        }
    }
}

