/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import avr8_burn_o_mat.AVR;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.TestPanel;
import de.lazyzero.kkMulticopterFlashTool.utils.Icons;
import de.lazyzero.kkMulticopterFlashTool.utils.PortScanner;
import de.lazyzero.kkMulticopterFlashTool.utils.SerialReader;
import gnu.io.PortInUseException;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class TestControllPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Logger logger = KKMulticopterFlashTool.getLogger();
    private Vector<AVR> avrs;
    private Vector<String> ports = new Vector();
    private CellConstraints cc;
    private JLabel portLabel;
    private JLabel controllerLabel;
    private JComboBox portComboBox;
    private JComboBox controllerComboBox;
    private JButton startButton;
    private JButton stopButton;
    private int baud = 9600;
    private SerialReader serialReader;
    private TestPanel parent;

    public TestControllPanel(TestPanel parent) {
        this.parent = parent;
        this.init();
        this.intiGUI();
        this.updateSerialPorts();
    }

    private void intiGUI() {
        this.cc = new CellConstraints();
        String panelColumns = "3dlu,pref, 3dlu, fill:pref:grow,3dlu, pref, 3dlu,pref,3dlu";
        String panelRows = "3dlu,pref,3dlu,pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new TitledBorder(Translatrix._("controller.settings")));
        this.portLabel = new JLabel(Translatrix._("port"));
        this.controllerLabel = new JLabel(Translatrix._("controller"));
        this.portComboBox = new JComboBox<String>(this.ports);
        this.controllerComboBox = new JComboBox<AVR>(this.avrs);
        this.startButton = new JButton(Translatrix._("start"), Icons.getIcon16("runit.png"));
        this.stopButton = new JButton(Translatrix._("stop"), Icons.getIcon16("not.png"));
        this.startButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.add((Component)this.controllerLabel, this.cc.xy(2, 2));
        this.add((Component)this.portLabel, this.cc.xy(2, 4));
        this.add((Component)this.controllerComboBox, this.cc.xyw(4, 2, 5));
        this.add((Component)this.portComboBox, this.cc.xy(4, 4));
        this.add((Component)this.startButton, this.cc.xy(6, 4));
        this.add((Component)this.stopButton, this.cc.xy(8, 4));
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(true);
    }

    private void init() {
        this.avrs = KKMulticopterFlashTool.getControllers();
        this.ports = PortScanner.listSerialPorts();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.startButton)) {
            try {
                this.startAction();
            }
            catch (PortInUseException e) {
                JOptionPane.showMessageDialog(this, Translatrix._("serialPort.portInUseException"));
                this.logger.log(Level.WARNING, e.getMessage());
            }
        } else if (event.getSource().equals(this.stopButton)) {
            this.stopAction();
        }
    }

    private void stopAction() {
        this.logger.info("stop serialReader");
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(true);
        this.serialReader.interrupt();
    }

    private void startAction() throws PortInUseException {
        this.logger.info("start serialReader");
        this.stopButton.setEnabled(true);
        this.startButton.setEnabled(false);
        this.serialReader = new SerialReader(this.baud, (String)this.portComboBox.getSelectedItem(), this.parent.getEvaluationPanel());
        this.serialReader.start();
    }

    private void updateSerialPorts() {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    String selectedItem = (String)TestControllPanel.this.portComboBox.getSelectedItem();
                    Vector<String> list = PortScanner.listSerialPorts();
                    for (String port : list) {
                        if (TestControllPanel.this.ports.contains(port)) continue;
                        System.out.println("add port to list: " + port);
                        TestControllPanel.this.ports.add(port);
                        TestControllPanel.this.portComboBox.setModel(new DefaultComboBoxModel(TestControllPanel.this.ports));
                        TestControllPanel.this.portComboBox.setSelectedItem(selectedItem);
                    }
                    try {
                        1.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.start();
    }
}

