/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.ToggledLable;
import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import lu.tudor.santec.i18n.Translatrix;

public class FirmwareListCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private boolean hasPot;
    private boolean hasLCD;
    private boolean hasPIEZO;
    private boolean hasMEMS;
    private boolean hasACC;
    private boolean hasCPPM;
    private boolean hasLVA;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        String panelColumns = "3dlu,fill:pref:grow";
        String panelRows = "1dlu,pref:grow,2dlu,pref:grow,2dlu,pref:grow,2dlu,pref:grow,1dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        panel.setLayout((LayoutManager)panelLayout);
        if (value == null) {
            value = Translatrix._("firmware.FirmwareCombobox.nonAvailable");
        }
        Color bg = isSelected ? list.getSelectionBackground() : list.getBackground().brighter();
        Color fg = Color.black;
        if (value instanceof Firmware) {
            this.setRequirementsAndFeatures((Firmware)value);
        }
        panel.setBackground(bg);
        if (!System.getProperty("os.name").toLowerCase().contains("mac")) {
            fg = isSelected ? list.getSelectionForeground() : list.getForeground();
            panel.setForeground(fg);
        }
        panel.setFont(list.getFont());
        if (value instanceof Firmware) {
            JPanel line3;
            JLabel line1;
            Firmware f = (Firmware)value;
            if (f.getController().equals("wii_bl") || f.getController().equals("wii_eeprom")) {
                line1 = new JLabel(String.valueOf(f.getName()) + " " + f.getVersion() + " " + f.getVersionName() + " by " + f.getAuthor());
            } else {
                String versionPrefix = f.getVersion().startsWith("daily") ? " " : " V";
                line1 = new JLabel(String.valueOf(f.getName()) + versionPrefix + f.getVersion() + " " + f.getVersionName() + " by " + f.getAuthor());
            }
            line1.setForeground(fg);
            JLabel line2 = new JLabel(f.getServer());
            line2.setFont(line2.getFont().deriveFont(line2.getFont().getSize2D() - 2.0f));
            line2.setForeground(fg);
            panel.add((Component)line1, cc.xy(2, 2));
            panel.add((Component)line2, cc.xy(2, 4));
            if (f.getTarget() == 0) {
                line3 = this.getLine(f, fg, bg);
                panel.add((Component)line3, cc.xy(2, 6));
            }
            if (f.getTarget() == 3) {
                line3 = this.getLine(f, fg, bg);
                JLabel line4 = new JLabel(f.getFileName());
                line4.setFont(line4.getFont().deriveFont(line4.getFont().getSize2D() - 2.0f));
                line4.setForeground(fg);
                panel.add((Component)line3, cc.xy(2, 6));
                panel.add((Component)line4, cc.xy(2, 8));
            }
            if (f.getTarget() == 5) {
                line3 = this.getLine(f, fg, bg);
                panel.add((Component)line3, cc.xy(2, 6));
            }
        } else {
            JLabel warning = new JLabel((String)value);
            warning.setForeground(fg);
            panel.add((Component)warning, cc.xy(2, 2));
        }
        return panel;
    }

    private JPanel getLine(Firmware firmware, Color fg, Color bg) {
        int target = firmware.getTarget();
        JPanel panel = new JPanel();
        CellConstraints cc = new CellConstraints();
        String panelRows = "pref";
        if (target == 0 || target == 3) {
            String panelColumns = "pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref";
            FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
            panel.setLayout((LayoutManager)panelLayout);
            panel.setForeground(fg);
            panel.setBackground(bg);
            panel.add((Component)new ToggledLable("pot", this.hasPot, fg, bg), cc.xy(1, 1));
            panel.add((Component)new ToggledLable("LCD", this.hasLCD, fg, bg), cc.xy(3, 1));
            panel.add((Component)new ToggledLable("piezo", this.hasPIEZO, fg, bg), cc.xy(5, 1));
            panel.add((Component)new ToggledLable("MEMS", this.hasMEMS, fg, bg), cc.xy(7, 1));
            panel.add((Component)new ToggledLable("acc", this.hasACC, fg, bg), cc.xy(9, 1));
            panel.add((Component)new ToggledLable("CPPM", this.hasCPPM, fg, bg), cc.xy(11, 1));
            panel.add((Component)new ToggledLable("LVA", this.hasLVA, fg, bg), cc.xy(13, 1));
        } else if (target == 5) {
            String panelColumns = "pref";
            FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
            panel.setLayout((LayoutManager)panelLayout);
            panel.setForeground(fg);
            panel.setBackground(bg);
            panel.add((Component)new ToggledLable(Translatrix._("flightstab.voltageWarning"), true, fg, bg), cc.xy(1, 1));
        }
        panel.setOpaque(true);
        return panel;
    }

    private void setRequirementsAndFeatures(Firmware firmware) {
        int features = firmware.getFeatures();
        int target = firmware.getTarget();
        if (target == 0 || target == 3) {
            if (features != -1) {
                this.hasPot = (features & 1) != 0;
                this.hasLCD = (features & 2) != 0;
                this.hasPIEZO = (features & 4) != 0;
                this.hasMEMS = (features & 8) != 0;
                this.hasACC = (features & 0x10) != 0;
                this.hasCPPM = (features & 0x20) != 0;
                this.hasLVA = (features & 0x40) != 0;
            } else {
                this.hasPot = false;
                this.hasLCD = false;
                this.hasPIEZO = false;
                this.hasMEMS = false;
                this.hasACC = false;
                this.hasCPPM = false;
                this.hasLVA = false;
            }
        }
    }
}

