/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import de.lazyzero.kkMulticopterFlashTool.utils.MD5;
import de.lazyzero.kkMulticopterFlashTool.utils.XmlReaderFirmwares;
import de.lazyzero.kkMulticopterFlashTool.utils.XmlWriterFirmwares;
import de.lazyzero.kkMulticopterFlashTool.utils.Zip;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public class FirmwareDownloadTest {
    private static String firmwareRepositoryURL;
    private static XmlReaderFirmwares firmwareReader;
    private static Vector<Firmware> firmwares;
    private static XmlWriterFirmwares firmwareWriter;

    public static void main(String[] args) {
        firmwareRepositoryURL = String.valueOf(System.getProperty("user.dir")) + "/firmwares.xml.simonk20140306";
        firmwareReader = new XmlReaderFirmwares();
        try {
            firmwareReader.readXmlFile("file://" + firmwareRepositoryURL);
            firmwares = firmwareReader.getFirmwares();
            for (Firmware firmware : firmwares) {
                File file;
                String md5Calculated = "N/A";
                if (firmware.getZipURL() != null) {
                    File f = FirmwareDownloadTest.downloadFile(firmware.getZipURL());
                    if (f != null) {
                        File fExtract = new File(firmware.getFileURL().toString().substring(7).trim());
                        try {
                            File file2 = Zip.unzip(f, fExtract);
                            md5Calculated = MD5.getMD5(file2);
                        }
                        catch (Exception e) {
                            System.err.println("File corrupt.");
                        }
                    }
                } else if (firmware.getFileURL() != null && (file = FirmwareDownloadTest.downloadFile(firmware.getFileURL())) != null) {
                    md5Calculated = MD5.getMD5(file);
                }
                if (!firmware.getMD5().equals(md5Calculated)) {
                    System.err.println("MD5 mismatch: " + firmware.getMD5());
                    firmware.setMD5(md5Calculated);
                }
                System.out.println("----------------------------------------------------------------------------------------");
            }
            firmwareWriter = new XmlWriterFirmwares(firmwareRepositoryURL, firmwares);
            firmwareWriter.writeXmlFile();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private static File downloadFile(URL url) {
        String filename = null;
        String tmpdir = "/tmp/kktest/";
        String urlPath = url.getPath();
        filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
        System.out.println("Download file: " + filename);
        filename = String.valueOf(tmpdir) + filename;
        File tmpFile = new File(filename);
        if (new File(tmpdir).mkdir()) {
            System.out.println("tmpdir created");
        }
        try {
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            FileOutputStream fos = new FileOutputStream(tmpFile);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            int x = 0;
            while ((x = in.read(data, 0, 1024)) >= 0) {
                bout.write(data, 0, x);
            }
            bout.close();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Download finished: " + filename);
        return tmpFile;
    }
}

