/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import de.lazyzero.kkMulticopterFlashTool.utils.xml.XMLElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.codec.EncoderException;

public class XmlWriterFirmwares {
    private String uri;
    private XMLElement xmlData;
    private Vector<Firmware> firmwares;

    public XmlWriterFirmwares(String uri, Vector<Firmware> firmwares) {
        this.uri = String.valueOf(uri) + "test";
        this.firmwares = firmwares;
        try {
            this.xmlData = this.createXML();
        }
        catch (EncoderException e) {
            e.printStackTrace();
        }
    }

    private XMLElement createXML() throws EncoderException {
        XMLElement xml = new XMLElement();
        xml.setName("firmwares");
        for (Firmware firmware : this.firmwares) {
            XMLElement firmwareE = new XMLElement();
            firmwareE.setName("firmware");
            firmwareE.setAttribute("name", firmware.getName());
            firmwareE.setAttribute("value", firmware.getVersion());
            XMLElement author = new XMLElement();
            author.setName("author");
            author.setAttribute("name", firmware.getAuthor());
            XMLElement server = new XMLElement();
            server.setName("server");
            server.setAttribute("name", firmware.getServer());
            XMLElement controller = new XMLElement();
            controller.setName("controller");
            controller.setAttribute("name", firmware.getController());
            controller.setAttribute("target", firmware.getTarget());
            XMLElement svn = new XMLElement();
            if (firmware.getSVN() != null) {
                svn.setName("svn");
                svn.setAttribute("url", firmware.getSVN());
                svn.setAttribute("name", firmware.getSVNname());
            }
            XMLElement zipfile = new XMLElement();
            zipfile.setName("zipfile");
            zipfile.setAttribute("url", firmware.getZipURL());
            XMLElement file = new XMLElement();
            file.setName("file");
            file.setAttribute("url", firmware.getFileURL());
            XMLElement md5 = new XMLElement();
            md5.setName("md5");
            md5.setAttribute("value", firmware.getMD5());
            XMLElement additionalOptions = new XMLElement();
            additionalOptions.setName("additionalOptions");
            additionalOptions.setAttribute("option", firmware.getAdditionalOptions());
            XMLElement commentURL = new XMLElement();
            commentURL.setName("commenturl");
            commentURL.setAttribute("url", firmware.getCommentURL());
            XMLElement feature = new XMLElement();
            feature.setName("feature");
            feature.setAttribute("value", firmware.getFeatures());
            XMLElement isDeprecated = new XMLElement();
            feature.setName("deprecated");
            feature.setAttribute("value", firmware.isDeprecated() ? "true" : "false");
            firmwareE.addChild(author);
            firmwareE.addChild(server);
            firmwareE.addChild(controller);
            if (firmware.getSVN() != "") {
                firmwareE.addChild(svn);
            }
            if (firmware.getZipURL() != null) {
                firmwareE.addChild(zipfile);
            }
            firmwareE.addChild(file);
            firmwareE.addChild(md5);
            firmwareE.addChild(additionalOptions);
            firmwareE.addChild(commentURL);
            if (firmware.getFeatures() != -1) {
                firmwareE.addChild(feature);
            }
            firmwareE.addChild(isDeprecated);
            xml.addChild(firmwareE);
        }
        return xml;
    }

    public void writeXmlFile() {
        byte[] buffer = this.xmlData.toString().getBytes();
        try {
            File file = new File(this.uri);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(buffer);
            fout.flush();
            fout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

