/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class EventRelay {
    protected Map methodListsTable = new HashMap();

    public void reset() {
        this.methodListsTable.clear();
    }

    public void addTarget(Component target, Class listenerClass, Class eventClass, String[] methodNames) {
        EventListener[] listeners = target.getListeners(listenerClass);
        Class[] argClass = new Class[]{eventClass};
        int i = 0;
        while (i < methodNames.length) {
            Vector<Object> methodList = new Vector<Object>();
            int j = 0;
            while (j < listeners.length) {
                EventListener listener = listeners[j];
                Class<?> objectClass = listener.getClass();
                try {
                    Method method = objectClass.getMethod(methodNames[i], argClass);
                    methodList.add(method);
                    methodList.add(listener);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                ++j;
            }
            this.methodListsTable.put(methodNames[i], methodList);
            ++i;
        }
    }

    protected void relay(String methodName, EventObject event) {
        Object[] args = new Object[1];
        List methodList = (List)this.methodListsTable.get(methodName);
        Iterator methods = methodList.iterator();
        while (methods.hasNext()) {
            Method method = (Method)methods.next();
            Object object = methods.next();
            args[0] = event;
            try {
                method.invoke(object, args);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

