/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.concord.swing.JAnnotationImageContainer;

class JAnnotationImageExample
extends JPanel {
    private static final Border SELECTED_BORDER = BorderFactory.createLoweredBevelBorder();
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    private JToolBar toolbar;
    private JTextArea textArea;
    private JAnnotationImageContainer annotationContainer;
    private JCheckBox annotationCheckBox;
    private ImageIcon image;

    JAnnotationImageExample() {
        super(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.textArea = new JTextArea();
        this.textArea.setPreferredSize(new Dimension(300, 100));
        JScrollPane sp = new JScrollPane(this.textArea);
        JLabel label = new JLabel("<html>Please make note of the above snapshot image in the following box (it will be automatically included in your report) :</html>");
        label.setAlignmentX(0.5f);
        label.setPreferredSize(new Dimension(300, 50));
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.annotationContainer = new JAnnotationImageContainer();
        this.annotationContainer.setBorder(BorderFactory.createLoweredBevelBorder());
        panel.add((Component)this.annotationContainer, "Center");
        Box box = Box.createVerticalBox();
        this.add((Component)box, "Center");
        box.add(new JScrollPane(panel));
        box.add(label);
        box.add(sp);
    }

    String showInputDialog(Component parent, ImageIcon image) {
        this.image = image;
        this.annotationContainer.setAnnotationImage((BufferedImage)image.getImage());
        this.annotationContainer.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
        if (this.annotationCheckBox != null) {
            this.annotationCheckBox.setSelected(false);
        }
        this.textArea.setText("");
        final JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(parent), "Add snapshot", true);
        dialog.setDefaultCloseOperation(2);
        dialog.getContentPane().add((Component)this, "Center");
        JPanel panel = new JPanel();
        dialog.getContentPane().add((Component)panel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        panel.add(button);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                dialog.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                JAnnotationImageExample.this.textArea.requestFocus();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return this.textArea.getText();
    }

    private void createAnnotationToolBar() {
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        this.toolbar.setMargin(new Insets(0, 0, 0, 0));
        this.toolbar.setLayout(new FlowLayout(0, 2, 0));
        this.toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        Dimension buttonDimension = new Dimension(24, 24);
        final ArrayList<JRadioButton> disableList = new ArrayList<JRadioButton>();
        this.annotationCheckBox = new JCheckBox("Annotation");
        this.annotationCheckBox.setToolTipText("Enable the tool for annotating the snapshot image");
        this.annotationCheckBox.setHorizontalAlignment(0);
        this.annotationCheckBox.setSelected(false);
        this.annotationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                final boolean b = e.getStateChange() == 1;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JAnnotationImageExample.this.annotationContainer.setEditMode(b);
                        Iterator it = disableList.iterator();
                        while (it.hasNext()) {
                            ((AbstractButton)it.next()).setEnabled(b);
                        }
                    }
                });
            }
        });
        this.toolbar.add(this.annotationCheckBox);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton rb = new JRadioButton(new ImageIcon(this.getClass().getResource("images/CallOutRectangle.gif")));
        rb.setSelected(true);
        rb.setToolTipText("Annotate a selected rectangular area");
        rb.setPreferredSize(buttonDimension);
        rb.setBorderPainted(true);
        rb.setHorizontalAlignment(0);
        rb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButton rbb = (JRadioButton)e.getSource();
                if (e.getStateChange() == 1) {
                    JAnnotationImageExample.this.annotationContainer.setChoosingMode(0);
                    rbb.setBorder(SELECTED_BORDER);
                    rbb.setBackground(Color.white);
                } else {
                    rbb.setBorder(EMPTY_BORDER);
                    rbb.setBackground(JAnnotationImageExample.this.getBackground());
                }
            }
        });
        bg.add(rb);
        this.toolbar.add(rb);
        disableList.add(rb);
        rb = new JRadioButton(new ImageIcon(this.getClass().getResource("images/CallOutEllipse.gif")));
        rb.setToolTipText("Annotate a selected circular area");
        rb.setPreferredSize(buttonDimension);
        rb.setBorderPainted(true);
        rb.setHorizontalAlignment(0);
        rb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButton rbb = (JRadioButton)e.getSource();
                if (e.getStateChange() == 1) {
                    JAnnotationImageExample.this.annotationContainer.setChoosingMode(1);
                    rbb.setBorder(SELECTED_BORDER);
                    rbb.setBackground(Color.white);
                } else {
                    rbb.setBorder(EMPTY_BORDER);
                    rbb.setBackground(JAnnotationImageExample.this.getBackground());
                }
            }
        });
        bg.add(rb);
        this.toolbar.add(rb);
        disableList.add(rb);
        Iterator it = disableList.iterator();
        while (it.hasNext()) {
            ((AbstractButton)it.next()).setEnabled(false);
        }
    }

    public static void main(String[] args) {
        JAnnotationImageExample snapshotComment = new JAnnotationImageExample();
        try {
            Robot robot = new Robot();
            BufferedImage bimg = robot.createScreenCapture(new Rectangle(0, 0, 300, 300));
            snapshotComment.showInputDialog(null, new ImageIcon(bimg));
        }
        catch (Throwable t) {
            System.out.println("Throwable " + t);
            t.printStackTrace();
        }
    }
}

