/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

class StyledToolTipUI
extends BasicToolTipUI {
    static StyledToolTipUI sharedInstance = new StyledToolTipUI();
    static JToolTip tip;
    protected CellRendererPane rendererPane;
    private static JTextPane textPane;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public StyledToolTipUI() {
        textPane = new JTextPane();
        textPane.setContentType("text/html");
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        tip = (JToolTip)c;
        this.rendererPane = new CellRendererPane();
        c.add(this.rendererPane);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c == null || this.rendererPane == null) {
            return;
        }
        Dimension size = c.getSize();
        textPane.setBackground(c.getBackground());
        this.rendererPane.paintComponent(g, textPane, c, 1, 1, size.width - 1, size.height - 1, true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        this.rendererPane.removeAll();
        textPane.setText(tipText);
        this.rendererPane.add(textPane);
        Dimension dim = textPane.getPreferredSize();
        if (dim == null) {
            dim = new Dimension(100, 100);
        }
        dim.width += 5;
        dim.height += 5;
        if (dim.width < 20) {
            dim.width = 20;
        }
        if (dim.height < 20) {
            dim.height = 20;
        }
        return dim;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

