/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class PropertySheet
extends Box {
    private Box box;
    private JScrollPane scroll;
    private int nRealProperties;
    private String panelName = "";
    protected Object object;
    protected Class objectClass;
    protected Hashtable writeMethods = new Hashtable();
    private Object[] args = new Object[1];
    private boolean clientMode;
    private Vector propertyHolders = new Vector();

    static {
        PropertyEditorManager.registerEditor(Integer.TYPE, IntegerEditor.class);
        PropertyEditorManager.registerEditor(Float.TYPE, FloatEditor.class);
        PropertyEditorManager.registerEditor(Long.TYPE, IntegerEditor.class);
        PropertyEditorManager.registerEditor(Double.TYPE, FloatEditor.class);
        PropertyEditorManager.registerEditor(Boolean.TYPE, BooleanEditor.class);
        PropertyEditorManager.registerEditor(String.class, StringEditor.class);
        PropertyEditorManager.registerEditor(Integer.class, IntegerEditor.class);
        PropertyEditorManager.registerEditor(Float.class, FloatEditor.class);
        PropertyEditorManager.registerEditor(Long.class, IntegerEditor.class);
        PropertyEditorManager.registerEditor(Double.class, FloatEditor.class);
        PropertyEditorManager.registerEditor(Boolean.class, BooleanEditor.class);
        PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
        PropertyEditorManager.registerEditor(Font.class, FontEditor.class);
    }

    public PropertySheet(Object o, String panelName) {
        this(o, panelName, true);
    }

    public PropertySheet(Object o, String panelName, boolean clientMode) {
        this(o, panelName, clientMode, null);
    }

    public PropertySheet(Object o, String panelName, boolean clientMode, Hashtable editableProps) {
        super(1);
        this.clientMode = clientMode;
        this.panelName = panelName;
        this.initialize(o, editableProps);
    }

    public void initialize(Object o) {
        this.initialize(o, null);
    }

    public void initialize(Object o, Hashtable validProps) {
        PropertyDescriptor[] pd = null;
        int nProperties = 0;
        if (o == null) {
            throw new IllegalArgumentException("PropertySheet initialize argument cannot be null");
        }
        this.objectClass = o.getClass();
        this.object = o;
        try {
            BeanInfo bi = this.getBeanInfo(this.objectClass);
            pd = bi.getPropertyDescriptors();
            nProperties = pd.length;
            this.nRealProperties = 0;
            int i = 0;
            while (i < pd.length) {
                if (!pd[i].isHidden()) {
                    if (validProps == null) {
                        ++this.nRealProperties;
                    } else if (validProps.get(pd[i].getName()) != null) {
                        ++this.nRealProperties;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.nRealProperties = 0;
        }
        if (this.nRealProperties < 1) {
            throw new IllegalArgumentException("PropertySheet there are no properties to show");
        }
        if (this.box == null) {
            this.box = Box.createVerticalBox();
            if (this.clientMode) {
                this.scroll = new JScrollPane(this.box);
                TitledBorder outerBorder = new TitledBorder(new BevelBorder(0), this.panelName);
                outerBorder.setTitleColor(Color.black);
                this.scroll.setBorder(outerBorder);
                this.add(this.scroll);
            } else {
                this.add(this.box);
            }
        } else {
            this.box.removeAll();
        }
        int i = 0;
        while (i < nProperties) {
            block40: {
                block41: {
                    if (pd[i].isHidden()) break block40;
                    if (validProps == null) break block41;
                    String label = (String)validProps.get(pd[i].getName());
                    if (label == null) break block40;
                    if (!label.equals("")) {
                        pd[i].setDisplayName(label);
                    }
                }
                PropertyEditor pEditor = null;
                Component customEditor = null;
                if (pd[i].getPropertyType() != null) {
                    pEditor = PropertyEditorManager.findEditor(pd[i].getPropertyType());
                }
                String[] tags = null;
                Method wMethod = pd[i].getWriteMethod();
                PropertyHolder ph = null;
                try {
                    if (pEditor != null) {
                        ph = new PropertyHolder(this, o, pd[i], pEditor);
                        this.propertyHolders.addElement(ph);
                        pEditor.addPropertyChangeListener(ph);
                        if (pEditor.supportsCustomEditor()) {
                            customEditor = pEditor.getCustomEditor();
                        } else if (pEditor.getTags() != null) {
                            tags = pEditor.getTags();
                        }
                        if (wMethod != null) {
                            this.writeMethods.put(pEditor, wMethod);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    pEditor = null;
                    customEditor = null;
                }
                Method rMethod = pd[i].getReadMethod();
                Object val = null;
                if (rMethod != null) {
                    try {
                        if (pEditor instanceof PropertyEditor) {
                            val = rMethod.invoke(o, null);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                } else {
                    pEditor = null;
                }
                if (pEditor != null) {
                    pEditor.setValue(val);
                    this.box.add(Box.createVerticalGlue());
                    JPanel pWrapper = new JPanel();
                    pWrapper.setLayout(new BorderLayout());
                    if (customEditor != null) {
                        pWrapper.add("Center", customEditor);
                        if (wMethod == null) {
                            customEditor.setEnabled(false);
                        }
                    } else if (tags != null) {
                        JComboBox<String> choice = new JComboBox<String>();
                        int it = 0;
                        while (it < tags.length) {
                            choice.addItem(tags[it]);
                            ++it;
                        }
                        pWrapper.add("Center", choice);
                        choice.setSelectedItem(pEditor.getAsText());
                        if (ph != null) {
                            choice.addActionListener(ph);
                        }
                        if (wMethod == null) {
                            choice.setEnabled(false);
                        }
                    }
                    TitledBorder titledBorder = new TitledBorder(pd[i].getDisplayName());
                    titledBorder.setTitleColor(Color.black);
                    pWrapper.setBorder(titledBorder);
                    this.box.add(pWrapper);
                    this.box.add(Box.createVerticalStrut(2));
                }
            }
            ++i;
        }
        this.box.add(Box.createVerticalGlue());
        this.box.add(Box.createVerticalStrut(5));
    }

    protected BeanInfo getBeanInfo(Class objectClass) throws IntrospectionException {
        BeanInfo beanInfo;
        try {
            if (objectClass.getName().equals("org.concord.collisions.ui.GUIPanel")) {
                Class<?> cl = Class.forName("org.concord.collisions.ui.GUIPanelBeanInfo");
                beanInfo = (BeanInfo)cl.newInstance();
            } else {
                beanInfo = Introspector.getBeanInfo(objectClass);
            }
        }
        catch (Exception e) {
            beanInfo = null;
        }
        if (beanInfo != null) {
            return beanInfo;
        }
        throw new IntrospectionException("Can't find beanInfo for class " + objectClass);
    }

    public String getPanelName() {
        return this.panelName;
    }

    public Object getObject() {
        return this.object;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dsuper = super.getPreferredSize();
        Insets insets = this.getInsets();
        if (this.box == null) {
            return dsuper;
        }
        Dimension d = this.box.getPreferredSize();
        Dimension minSize = this.scroll != null ? ((TitledBorder)this.scroll.getBorder()).getMinimumSize(this) : null;
        d.height += (this.nRealProperties + 2) * 5;
        if (minSize != null) {
            d.width = Math.max(d.width, minSize.width);
        }
        if (d.width < 200) {
            d.width = 200;
        }
        return d;
    }

    public void restoreOldValues() {
        if (this.propertyHolders == null || this.propertyHolders.size() < 1) {
            return;
        }
        int i = 0;
        while (i < this.propertyHolders.size()) {
            PropertyHolder ph = (PropertyHolder)this.propertyHolders.elementAt(i);
            ph.restoreOldValue();
            ++i;
        }
    }

    public void writeNewValues() {
        if (this.propertyHolders == null || this.propertyHolders.size() < 1) {
            return;
        }
        int i = 0;
        while (i < this.propertyHolders.size()) {
            PropertyHolder ph = (PropertyHolder)this.propertyHolders.elementAt(i);
            ph.writeNewValue();
            ++i;
        }
    }

    public void propertyValueChanged(PropertyHolder ph) {
        this.firePropertyChange(ph.descriptor.getName(), ph.oldValue, ph.newValue);
    }

    public static class BooleanEditor
    extends CustomEditor {
        protected JPanel buttonPanel = new JPanel();
        protected JRadioButton trueButton = new JRadioButton("true");
        protected JRadioButton falseButton = new JRadioButton("false");
        protected ButtonGroup group = new ButtonGroup();
        protected ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BooleanEditor.this.firePropertyChange();
            }
        };

        public BooleanEditor() {
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.add(this.trueButton);
            this.buttonPanel.add(this.falseButton);
            this.group.add(this.trueButton);
            this.group.add(this.falseButton);
            this.trueButton.addActionListener(this.actionListener);
            this.falseButton.addActionListener(this.actionListener);
            this.customEditor = this.buttonPanel;
        }

        @Override
        public String getAsText() {
            return this.trueButton.isSelected() ? "true" : "false";
        }

        @Override
        public void setAsText(String value) {
            if (value.toLowerCase().equals("true")) {
                this.trueButton.setSelected(true);
            } else {
                this.falseButton.setSelected(true);
            }
        }

        @Override
        public Object getValue() {
            return new Boolean(this.trueButton.isSelected());
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Boolean) {
                this.setAsText(value.toString());
            }
        }
    }

    public static class ColorEditor
    extends CustomEditor
    implements ActionListener {
        protected JButton colorButton = new JButton("Color");
        protected JColorChooser colorChooser = new JColorChooser();

        public ColorEditor() {
            this.colorButton.addActionListener(this);
            this.customEditor = this.colorButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = this.colorButton.getBackground();
            color = JColorChooser.showDialog(this.colorButton, "Choose Color", color);
            this.colorButton.setBackground(color);
            this.firePropertyChange();
        }

        @Override
        public Object getValue() {
            return this.colorButton.getBackground();
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Color) {
                this.colorButton.setBackground((Color)value);
            }
        }
    }

    public static class CustomEditor
    extends PropertyEditorSupport {
        protected Component customEditor = new JTextField();

        @Override
        public Component getCustomEditor() {
            return this.customEditor;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }
    }

    public static class FloatEditor
    extends StringEditor {
        DecimalFormat format = new DecimalFormat();

        public FloatEditor() {
            this.format.setMaximumIntegerDigits(10);
            this.format.setMinimumIntegerDigits(1);
            this.format.setMaximumFractionDigits(10);
            this.format.setMinimumFractionDigits(1);
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.stringEditor.getText());
        }
    }

    public static class FontEditor
    extends CustomEditor {
        protected static final GraphicsEnvironment graphics = GraphicsEnvironment.getLocalGraphicsEnvironment();
        protected static final String[] families = graphics.getAvailableFontFamilyNames();
        protected static final int[] styles;
        protected static final String[] styleNames;
        protected static final int[] sizes;
        protected JPanel fontPanel = new JPanel();
        protected JComboBox fontFamily = new JComboBox();
        protected JComboBox fontStyle = new JComboBox();
        protected JComboBox fontSize = new JComboBox();
        protected ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontEditor.this.firePropertyChange();
            }
        };

        static {
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            styles = nArray;
            styleNames = new String[]{"Plain", "Bold", "Italic"};
            sizes = new int[]{6, 7, 8, 9, 10, 12, 14, 16, 18, 20, 24, 36, 48};
        }

        public FontEditor() {
            this.fontPanel.setLayout(new FlowLayout());
            this.fontPanel.add(this.fontFamily);
            this.fontPanel.add(this.fontStyle);
            this.fontPanel.add(this.fontSize);
            int i = 0;
            while (i < families.length) {
                this.fontFamily.addItem(families[i]);
                ++i;
            }
            i = 0;
            while (i < styles.length) {
                this.fontStyle.addItem(styleNames[i]);
                ++i;
            }
            i = 0;
            while (i < sizes.length) {
                this.fontSize.addItem("" + sizes[i]);
                ++i;
            }
            this.fontFamily.addActionListener(this.actionListener);
            this.fontStyle.addActionListener(this.actionListener);
            this.fontSize.addActionListener(this.actionListener);
            this.customEditor = this.fontPanel;
        }

        public void actionPerformed(ActionEvent e) {
            this.firePropertyChange();
        }

        @Override
        public Object getValue() {
            String family = (String)this.fontFamily.getSelectedItem();
            int style = styles[this.fontStyle.getSelectedIndex()];
            int size = Integer.valueOf((String)this.fontSize.getSelectedItem());
            return new Font(family, style, size);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Font) {
                Font font = (Font)value;
                String styleName = null;
                int i = 0;
                while (i < styles.length) {
                    if (font.getStyle() == styles[i]) {
                        styleName = styleNames[i];
                        break;
                    }
                    ++i;
                }
                String family = font.getFamily();
                this.fontFamily.setSelectedItem(family);
                if (styleName != null) {
                    this.fontStyle.setSelectedItem(styleName);
                }
                int size = font.getSize();
                this.fontSize.setSelectedItem("" + font.getSize());
            }
        }
    }

    public static class IntegerEditor
    extends StringEditor {
        DecimalFormat format = new DecimalFormat();

        public IntegerEditor() {
            this.format.setMaximumIntegerDigits(10);
            this.format.setMinimumIntegerDigits(1);
            this.format.setMaximumFractionDigits(0);
            this.format.setMinimumFractionDigits(0);
            this.setFormat(this.format);
        }

        @Override
        public Object getValue() {
            return Integer.valueOf(this.stringEditor.getText());
        }
    }

    protected class PropertyHolder
    implements PropertyChangeListener,
    ActionListener {
        protected PropertyDescriptor descriptor;
        protected Method writeMethod;
        protected Method readMethod;
        protected Object oldValue;
        protected boolean valueChanged = false;
        protected Object newValue;
        protected Object propertyOwner;
        private Object[] args = new Object[1];
        private PropertyEditor pEditor;
        private PropertySheet owner;

        public PropertyHolder(PropertySheet owner, Object propertyOwner, PropertyDescriptor descriptor, PropertyEditor pEditor) {
            this.owner = owner;
            this.propertyOwner = propertyOwner;
            this.descriptor = descriptor;
            this.pEditor = pEditor;
            this.defineMethods();
        }

        void defineMethods() {
            if (this.propertyOwner == null || this.descriptor == null) {
                return;
            }
            this.writeMethod = this.descriptor.getWriteMethod();
            this.readMethod = this.descriptor.getReadMethod();
            try {
                this.oldValue = this.readMethod.invoke(this.propertyOwner, null);
            }
            catch (InvocationTargetException e) {
                System.out.println("PropertyHolder defineMethods Exception " + e);
            }
            catch (IllegalAccessException e) {
                System.out.println("PropertyHolder defineMethods Exception " + e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getSource() instanceof PropertyEditor)) {
                return;
            }
            this.valueChanged = true;
            this.newValue = ((PropertyEditor)evt.getSource()).getValue();
            this.owner.propertyValueChanged(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)e.getSource();
                this.pEditor.setAsText((String)comboBox.getSelectedItem());
            }
        }

        public void restoreOldValue() {
            this.writeValue(this.oldValue);
        }

        public void writeNewValue() {
            this.writeValue(this.newValue);
        }

        private void writeValue(Object value) {
            if (this.writeMethod != null && this.valueChanged) {
                try {
                    this.args[0] = value;
                    this.writeMethod.invoke(this.propertyOwner, this.args);
                    this.valueChanged = false;
                }
                catch (InvocationTargetException ie) {
                    if (ie.getTargetException() instanceof PropertyVetoException) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class StringEditor
    extends CustomEditor {
        protected JFormattedTextField stringEditor;
        protected KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                StringEditor.this.firePropertyChange();
            }
        };

        public StringEditor(Format format) {
            this.setFormat(format);
        }

        public StringEditor() {
            this.setFormat(null);
        }

        protected void setFormat(Format format) {
            this.stringEditor = format == null ? new JFormattedTextField() : new JFormattedTextField(format);
            this.stringEditor.addKeyListener(this.keyListener);
            this.customEditor = this.stringEditor;
        }

        @Override
        public String getAsText() {
            return this.stringEditor.getText();
        }

        @Override
        public void setAsText(String text) {
            this.stringEditor.setText(text);
        }

        @Override
        public Object getValue() {
            return this.getAsText();
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                value = "";
            }
            this.stringEditor.setText(value.toString());
        }
    }
}

