/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import org.concord.swing.ExtensionFileFilter;
import org.concord.swing.editor.XMEditor;

public class XMEditorKit
extends StyledEditorKit {
    protected Hashtable imageTable = new Hashtable();
    protected Hashtable imageFileTable = new Hashtable();

    public static class BackgroundAction
    extends XMTextAction {
        protected JColorChooser colorChooser = new JColorChooser();

        public BackgroundAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            XMEditor editor = this.getXMEditor(event);
            if (editor != null) {
                Color color = JColorChooser.showDialog(editor, "Choose Background Color", editor.getBackground());
                if (event != null && event.getSource() == editor) {
                    String s = event.getActionCommand();
                    try {
                        color = Color.decode(s);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (color != null) {
                    editor.setBackground(color);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(editor);
                }
            }
        }
    }

    public static class InsertImageAction
    extends XMTextAction {
        protected JFileChooser imageFileChooser = new JFileChooser();

        public InsertImageAction(String name) {
            super(name);
            ExtensionFileFilter filter = new ExtensionFileFilter();
            filter.addExtension("jpg");
            filter.addExtension("gif");
            filter.setDescription("JPG & GIF Images");
            this.imageFileChooser.setFileFilter(filter);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            XMEditor editor = this.getXMEditor(event);
            if (editor != null) {
                XMEditorKit editorKit = (XMEditorKit)editor.getEditorKit();
                int returnVal = this.imageFileChooser.showOpenDialog(editor);
                if (returnVal == 0) {
                    File imageFile = this.imageFileChooser.getSelectedFile();
                    ImageIcon image = new ImageIcon(imageFile.getAbsolutePath());
                    editor.insertIcon(image);
                    editorKit.imageTable.put(image, imageFile);
                    editorKit.imageFileTable.put(imageFile.getAbsolutePath(), image);
                }
            }
        }
    }

    public static class TextBackgroundAction
    extends XMTextAction {
        protected JColorChooser colorChooser = new JColorChooser();

        public TextBackgroundAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            XMEditor editor = this.getXMEditor(event);
            if (editor != null) {
                Color color = JColorChooser.showDialog(editor, "Choose Background Color", Color.white);
                if (event != null && event.getSource() == editor) {
                    String s = event.getActionCommand();
                    try {
                        color = Color.decode(s);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (color != null) {
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    StyleConstants.setBackground(attr, color);
                    this.setCharacterAttributes(editor, attr, false);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(editor);
                }
            }
        }
    }

    public static class TextColorAction
    extends XMTextAction {
        protected JColorChooser colorChooser = new JColorChooser();

        public TextColorAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            XMEditor editor = this.getXMEditor(event);
            if (editor != null) {
                Color color = JColorChooser.showDialog(editor, "Choose Background Color", Color.white);
                if (event != null && event.getSource() == editor) {
                    String s = event.getActionCommand();
                    try {
                        color = Color.decode(s);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (color != null) {
                    SimpleAttributeSet attr = new SimpleAttributeSet();
                    StyleConstants.setForeground(attr, color);
                    this.setCharacterAttributes(editor, attr, false);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(editor);
                }
            }
        }
    }

    public static class XMTextAction
    extends StyledEditorKit.StyledTextAction {
        public XMTextAction(String name) {
            super(name);
        }

        public XMEditor getXMEditor(ActionEvent event) {
            XMEditor editor = (XMEditor)super.getEditor(event);
            if (editor == null) {
                Object c = event.getSource();
                while (c != null) {
                    if (!((c = ((Container)c).getParent()) instanceof JPopupMenu) || !((c = ((JPopupMenu)c).getInvoker()) instanceof XMEditor)) continue;
                    editor = (XMEditor)c;
                    break;
                }
            }
            return editor;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
        }
    }
}

