/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;

public class AVR {
    public static final int LOWER_NIBBLE = 0;
    public static final int HIGHER_NIBBLE = 1;
    public static final String HFUSE = "hfuse";
    public static final String LFUSE = "lfuse";
    public static final String EFUSE = "efuse";
    private String lfuse;
    private String hfuse;
    private String efuse;
    private String m_name;
    private String m_caption;
    private String desc;
    private int eepromSize;
    private String hfuseMask;
    private String lfuseMask;
    private int bootloaderAddress = 1024;

    public AVR() {
    }

    public AVR(String name, String caption) {
        this.m_name = name;
        this.m_caption = caption;
    }

    public AVR(String name, String desc, String caption, int eepromSize, String lfuse, String hfuse) {
        this(name, desc, caption, eepromSize, lfuse, hfuse, null);
    }

    public AVR(String name, String desc, String caption, int eepromSize, String lfuse, String hfuse, String efuse) {
        this.m_name = name;
        this.m_caption = caption;
        this.desc = desc;
        this.lfuse = lfuse;
        this.hfuse = hfuse;
        this.setEfuse(efuse);
        this.eepromSize = eepromSize;
    }

    public AVR(String name, String desc, String caption, int eepromSize, String lfuse, String hfuse, int bootloaderAddress) {
        this.m_name = name;
        this.m_caption = caption;
        this.desc = desc;
        this.lfuse = lfuse;
        this.hfuse = hfuse;
        this.eepromSize = eepromSize;
        this.bootloaderAddress = bootloaderAddress;
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        String name = String.valueOf(this.getName()) + (this.getDescription() != null ? " (" + this.getDescription() + ")" : "");
        return name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getCaption() {
        return this.m_caption;
    }

    public String getCaptionAliasFree() {
        if (this.m_caption.equals("kkplusboot")) {
            return "m168p";
        }
        if (this.m_caption.equals("flycam_blackp")) {
            return "m168p";
        }
        if (this.m_caption.equals("flycam_black")) {
            return "m168";
        }
        if (this.m_caption.equals("esc")) {
            return "m8";
        }
        if (this.m_caption.equals("wii_bl")) {
            return "m8";
        }
        if (this.m_caption.equals("wii_eeprom")) {
            return "m8";
        }
        if (this.m_caption.equals(KKMulticopterFlashTool.WIIESC_BOOTLOADER)) {
            return "m8";
        }
        if (this.m_caption.equals("escp")) {
            return "m8";
        }
        if (this.m_caption.equals("esc_light")) {
            return "m8";
        }
        if (this.m_caption.equals("smartlcd")) {
            return "m48p";
        }
        if (this.m_caption.equals("i86")) {
            return "m168p";
        }
        if (this.m_caption.equals("i86l")) {
            return "m168p";
        }
        if (this.m_caption.equals("openflightV1")) {
            return "m168p";
        }
        if (this.m_caption.equals("openflightV2")) {
            return "m168p";
        }
        if (this.m_caption.equals("openflightSM")) {
            return "m168p";
        }
        if (this.m_caption.equals("openflightPROG")) {
            return "m8";
        }
        return this.m_caption;
    }

    public String getLfuse() {
        return this.lfuse;
    }

    public void setLfuse(String lfuse) {
        this.lfuse = lfuse;
    }

    public String getHfuse() {
        return this.hfuse;
    }

    public void setHfuse(String hfuse) {
        this.hfuse = hfuse;
    }

    public int getEepromSize() {
        return this.eepromSize;
    }

    public void setEepromSize(int eepromSize) {
        this.eepromSize = eepromSize;
    }

    public int getBootloaderAddress() {
        return this.bootloaderAddress;
    }

    public void setBootloaderAddress(int bootloaderAddress) {
        this.bootloaderAddress = bootloaderAddress;
    }

    public void changeFuseNibble(String fuse, int nibble, String exchangeBy) {
        String value = "";
        if (fuse.equals(HFUSE)) {
            value = this.getHfuse();
        } else if (fuse.equals(LFUSE)) {
            value = this.getLfuse();
        }
        String fuseAsString = Integer.toHexString(Integer.parseInt(value));
        fuseAsString = nibble == 0 ? fuseAsString.substring(0, 1).concat(exchangeBy) : exchangeBy.concat(fuseAsString.substring(1));
        if (fuse.equals(HFUSE)) {
            this.setHfuse(String.valueOf(Integer.parseInt(fuseAsString, 16)));
        } else if (fuse.equals(LFUSE)) {
            this.setLfuse(String.valueOf(Integer.parseInt(fuseAsString, 16)));
        }
    }

    public String getEfuse() {
        return this.efuse;
    }

    public void setEfuse(String efuse) {
        this.efuse = efuse;
    }
}

