/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.GithubPanel;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.GithubPanelListener;
import de.lazyzero.kkMulticopterFlashTool.utils.avra.Avra;
import de.lazyzero.kkMulticopterFlashTool.utils.avra.SimonKAvraCommandLine;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lu.tudor.santec.i18n.Translatrix;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public class SimonkEditorPanel
extends JPanel
implements ActionListener,
GithubPanelListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    KKMulticopterFlashTool parent;
    private RSyntaxTextArea tgyTextArea;
    private JButton compileButton;
    private JButton saveButton;
    private ButtonBarBuilder2 bar;
    private JButton saveCompileButton;
    private CellConstraints cc;
    private GithubPanel githubPanel;
    private JTabbedPane tabs;
    private RSyntaxTextArea incTextArea;
    private boolean tgyChanged;
    private boolean incChanged;

    public SimonkEditorPanel(KKMulticopterFlashTool parent) {
        this.parent = parent;
        this.cc = new CellConstraints();
        String panelColumns = "fill:pref:grow";
        String panelRows = "pref,3dlu,fill:pref:grow,3dlu,pref";
        FormLayout formLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)formLayout);
        this.githubPanel = new GithubPanel("sim-/tgy");
        this.githubPanel.addGithubPanelListener(this);
        this.tgyTextArea = new RSyntaxTextArea(20, 60);
        this.tgyTextArea.setSyntaxEditingStyle("text/asm");
        this.tgyTextArea.setCodeFoldingEnabled(true);
        this.tgyTextArea.setAntiAliasingEnabled(true);
        RTextScrollPane tgyEditorPane = new RTextScrollPane((Component)this.tgyTextArea);
        tgyEditorPane.setFoldIndicatorEnabled(true);
        tgyEditorPane.setLineNumbersEnabled(true);
        this.incTextArea = new RSyntaxTextArea(20, 60);
        this.incTextArea.setSyntaxEditingStyle("text/asm");
        this.incTextArea.setCodeFoldingEnabled(true);
        this.incTextArea.setAntiAliasingEnabled(true);
        RTextScrollPane incEditorPane = new RTextScrollPane((Component)this.incTextArea);
        incEditorPane.setFoldIndicatorEnabled(true);
        incEditorPane.setLineNumbersEnabled(true);
        this.tabs = new JTabbedPane();
        this.tabs.add("empty", (Component)tgyEditorPane);
        this.tabs.add("empty", (Component)incEditorPane);
        this.saveButton = new JButton(Translatrix._("save"));
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(false);
        this.compileButton = new JButton(Translatrix._("compile"));
        this.compileButton.addActionListener(this);
        this.compileButton.setEnabled(false);
        this.saveCompileButton = new JButton(String.valueOf(Translatrix._("save")) + " & " + Translatrix._("compile"));
        this.saveCompileButton.addActionListener(this);
        this.saveCompileButton.setEnabled(false);
        this.bar = new ButtonBarBuilder2();
        this.bar.addButton((JComponent)this.saveButton);
        this.bar.addButton((JComponent)this.compileButton);
        this.bar.addGlue();
        this.bar.addUnrelatedGap();
        this.bar.addButton((JComponent)this.saveCompileButton);
        this.add((Component)this.githubPanel, this.cc.xy(1, 1));
        this.add((Component)this.tabs, this.cc.xy(1, 3));
        this.add((Component)this.bar.getPanel(), this.cc.xy(1, 5));
        try {
            Theme theme = Theme.load((InputStream)SimonkEditorPanel.class.getResourceAsStream("/de/lazyzero/kkMulticopterFlashTool/gui/widgets/dark.xml"));
            theme.apply(this.tgyTextArea);
            theme.apply(this.incTextArea);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean setLinetoFirstof(RSyntaxTextArea area, String text) {
        SearchContext context = new SearchContext();
        if (text.length() == 0) {
            return false;
        }
        area.setCaretPosition(0);
        context.setSearchFor(text);
        context.setMatchCase(true);
        context.setRegularExpression(false);
        context.setSearchForward(true);
        context.setWholeWord(false);
        return SearchEngine.find((JTextArea)area, (SearchContext)context).wasFound();
    }

    private String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }

    private boolean writeFile(RSyntaxTextArea rSysntaxTextArea, String filename) {
        byte[] dataToWrite = rSysntaxTextArea.getText().getBytes();
        try {
            FileOutputStream out = new FileOutputStream(filename);
            out.write(dataToWrite);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.saveButton)) {
            if (this.tgyChanged) {
                this.tgyChanged = !this.writeFile(this.tgyTextArea, String.valueOf(this.githubPanel.getPath()) + File.separatorChar + "tgy.asm");
                this.tabs.setTitleAt(0, "tgy.asm - " + this.githubPanel.getVersion());
            }
            if (this.incChanged) {
                this.incChanged = !this.writeFile(this.incTextArea, String.valueOf(this.githubPanel.getPath()) + File.separatorChar + this.githubPanel.getTarget() + ".inc");
                this.tabs.setTitleAt(1, String.valueOf(this.githubPanel.getTarget()) + ".inc - " + this.githubPanel.getVersion());
            }
            this.enableSave();
        } else if (e.getSource().equals(this.compileButton)) {
            this.parent.clearText();
            this.parent.println(Translatrix._("compile.simonk.start"));
            File sources = new File(this.githubPanel.getPath());
            Avra avra = new Avra(this.parent, new SimonKAvraCommandLine(this.githubPanel.getTarget(), sources));
            if (avra.compile()) {
                this.parent.println(Translatrix._("compile.simonk.success"));
                this.parent.setHexFile(avra.getHexFile(), false);
                avra.clean();
            } else {
                this.parent.err("Compiling failed.");
                this.parent.switch2ProgrammingTab();
            }
        } else if (e.getSource().equals(this.saveCompileButton)) {
            this.saveButton.doClick();
            this.compileButton.doClick();
        }
    }

    @Override
    public void githubPanelChanged(int state) {
        System.out.println("downloadStateChanged: " + state);
        if (state == 2) {
            try {
                System.out.println("Open File from: " + this.githubPanel.getPath());
                this.tgyTextArea.setText(this.readFile(String.valueOf(this.githubPanel.getPath()) + File.separatorChar + "tgy.asm"));
                this.setLinetoFirstof(this.tgyTextArea, ".equ");
                this.tabs.setTitleAt(0, "tgy.asm - " + this.githubPanel.getVersion());
                this.tgyTextArea.getDocument().addDocumentListener(this);
                this.tgyChanged = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (state == 0) {
            this.tgyTextArea.setText("");
            this.tgyTextArea.revalidate();
            this.tgyTextArea.repaint();
            this.incTextArea.setText("");
            this.incTextArea.revalidate();
            this.incTextArea.repaint();
            this.tabs.setTitleAt(0, Translatrix._("empty"));
            this.tabs.setTitleAt(1, Translatrix._("empty"));
            this.tgyTextArea.getDocument().removeDocumentListener(this);
            this.incTextArea.getDocument().removeDocumentListener(this);
            this.tgyChanged = false;
            this.incChanged = false;
        } else if (state == 9999) {
            try {
                this.incTextArea.setText(this.readFile(String.valueOf(this.githubPanel.getPath()) + File.separatorChar + this.githubPanel.getTarget() + ".inc"));
                this.setLinetoFirstof(this.incTextArea, ".equ");
                this.tabs.setTitleAt(1, String.valueOf(this.githubPanel.getTarget()) + ".inc - " + this.githubPanel.getVersion());
                this.incTextArea.getDocument().addDocumentListener(this);
                this.incChanged = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.enableSave();
    }

    private void enableSave() {
        this.saveButton.setEnabled(this.incChanged || this.tgyChanged);
        this.saveCompileButton.setEnabled(this.incChanged || this.tgyChanged);
        this.enableCompile();
    }

    private void enableCompile() {
        this.compileButton.setEnabled(!this.incChanged && !this.tgyChanged);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (e.getDocument().equals(this.tgyTextArea.getDocument())) {
            this.tabs.setTitleAt(0, "*tgy.asm - " + this.githubPanel.getVersion());
            this.tgyChanged = true;
        } else if (e.getDocument().equals(this.incTextArea.getDocument())) {
            this.tabs.setTitleAt(1, "*" + this.githubPanel.getTarget() + ".inc - " + this.githubPanel.getVersion());
            this.incChanged = true;
        }
        System.out.println("changedUpdate: " + e.getLength());
        this.enableSave();
    }
}

