/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.ArduinoUSBLinkerUploader;
import de.lazyzero.kkMulticopterFlashTool.gui.FirmwareCommitForm;
import de.lazyzero.kkMulticopterFlashTool.gui.FirmwareDownloadFrame;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.JNamedIntMenuItem;
import de.lazyzero.kkMulticopterFlashTool.utils.Icons;
import de.lazyzero.kkMulticopterFlashTool.utils.SendLogFile;
import de.lazyzero.kkMulticopterFlashTool.utils.XmlReaderFirmwares;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Scanner;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import lu.tudor.santec.i18n.Translatrix;

public class kkMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private JMenu setup;
    private JMenu info;
    private JMenu help;
    private JMenu contribute;
    private JMenu tools;
    private JMenuBar bar;
    private KKMulticopterFlashTool parent;
    protected XmlReaderFirmwares firmwareReader;
    private JNamedIntMenuItem countdown;
    private ArduinoUSBLinkerUploader arduinoUploader;

    public kkMenu(KKMulticopterFlashTool parent, XmlReaderFirmwares firmwareReader) {
        this.parent = parent;
        this.firmwareReader = firmwareReader;
        this.initSetupMenu();
        this.initHelpMenu();
        this.initInfoMenu();
        this.initContributeMenu();
        this.initToolsMenu();
        this.bar = new JMenuBar();
        this.bar.add(this.setup);
        this.bar.add(this.contribute);
        this.bar.add(this.tools);
        this.bar.add(this.help);
        this.bar.add(this.info);
    }

    public JMenuBar getBar() {
        return this.bar;
    }

    private void initToolsMenu() {
        this.tools = new JMenu(Translatrix._("tools"));
        JMenu arduinoUSBLinkerUploadItemMenu = new JMenu(Translatrix._("tools.arduinoUSBLinkerUpload"));
        arduinoUSBLinkerUploadItemMenu.setIcon(Icons.getIcon22("agt_utilities.png"));
        this.tools.add(arduinoUSBLinkerUploadItemMenu);
        this.createArduinoUSBlinkerUploadMenuItems(arduinoUSBLinkerUploadItemMenu);
    }

    private void createArduinoUSBlinkerUploadMenuItems(JMenu arduinoUSBLinkerUploadItemMenu) {
        this.arduinoUploader = new ArduinoUSBLinkerUploader(this.parent);
        Iterator<String> arduinos = this.arduinoUploader.getArduinos();
        while (arduinos.hasNext()) {
            final String name = arduinos.next();
            JMenuItem mi = new JMenuItem(name);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    kkMenu.this.arduinoUploader.upload(name);
                }
            });
            arduinoUSBLinkerUploadItemMenu.add(mi);
        }
    }

    private void initContributeMenu() {
        this.contribute = new JMenu(Translatrix._("contribute"));
        JMenuItem mailItem = new JMenuItem(Translatrix._("contribute.mail"));
        mailItem.setMnemonic(Translatrix._("contribute.mail.key").charAt(0));
        mailItem.setIcon(Icons.getIcon22("mail.png"));
        this.contribute.add(mailItem);
        JMenuItem submitFirmwareItem = new JMenuItem(Translatrix._("contribute.submitFirmware"));
        submitFirmwareItem.setMnemonic(Translatrix._("contribute.submitFirmware.key").charAt(0));
        submitFirmwareItem.setIcon(Icons.getIcon22("mail.png"));
        this.contribute.add(submitFirmwareItem);
        submitFirmwareItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirmwareCommitForm fcf = new FirmwareCommitForm(kkMenu.this.firmwareReader);
                fcf.sendMail();
            }
        });
        mailItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendLogFile slf = new SendLogFile();
                slf.sendMail(KKMulticopterFlashTool.VERSION, KKMulticopterFlashTool.LOG_FILE, kkMenu.this.parent.getText());
            }
        });
    }

    private void initHelpMenu() {
        this.help = new JMenu(Translatrix._("help"));
        JMenuItem escdbItem = new JMenuItem(Translatrix._("help.ESCDB"));
        escdbItem.setMnemonic(Translatrix._("help.ESCDB.key").charAt(0));
        this.help.add(escdbItem);
        JMenuItem ardLnkItem = new JMenuItem(Translatrix._("help.ardLnk"));
        ardLnkItem.setMnemonic(Translatrix._("help.ardLnk.key").charAt(0));
        this.help.add(ardLnkItem);
        this.help.add(new JSeparator());
        JMenuItem KKhomeItem = new JMenuItem(Translatrix._("help.kkhome"));
        KKhomeItem.setMnemonic(Translatrix._("help.kkhome.key").charAt(0));
        KKhomeItem.setIcon(Icons.getIcon22("KK.png"));
        this.help.add(KKhomeItem);
        JMenuItem KRManualItem = new JMenuItem(Translatrix._("help.krManual"));
        KRManualItem.setMnemonic(Translatrix._("help.krManual.key").charAt(0));
        KRManualItem.setIcon(Icons.getIcon22("minsoo.png"));
        this.help.add(KRManualItem);
        this.help.addSeparator();
        JMenuItem helpItem = new JMenuItem(Translatrix._("help.help"));
        helpItem.setMnemonic(Translatrix._("help.help.key").charAt(0));
        helpItem.setIcon(Icons.getIcon22("LZ.png"));
        this.help.add(helpItem);
        KRManualItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                kkMenu.openURL("http://www.kkmulticopter.kr/index.html?modea=manual");
            }
        });
        KKhomeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                kkMenu.openURL("http://www.kkmulticopter.com/index.php?option=com_content&view=article&id=55&Itemid=57");
            }
        });
        helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                kkMenu.openURL("http://www.lazyzero.de/en/modellbau/kkmulticopterflashtool");
            }
        });
        escdbItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                kkMenu.openURL("http://wiki.openpilot.org/display/Doc/RapidESC+Database");
            }
        });
        ardLnkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                kkMenu.openURL("https://github.com/c---/ArduinoUSBLinker#readme");
            }
        });
    }

    private void initInfoMenu() {
        this.info = new JMenu(Translatrix._("info"));
        JMenuItem licenseItem = new JMenuItem(Translatrix._("info.license"));
        licenseItem.setMnemonic(Translatrix._("info.license.key").charAt(0));
        licenseItem.setIcon(Icons.getIcon22("3floppy_unmount.png"));
        this.info.add(licenseItem);
        JMenuItem aboutItem = new JMenuItem(Translatrix._("info.about"));
        aboutItem.setMnemonic(Translatrix._("info.about.key").charAt(0));
        aboutItem.setIcon(Icons.getIcon22("error.png"));
        this.info.add(aboutItem);
        licenseItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel title = new JLabel("<HTML><H2>KKmulticopter Flash Tool " + KKMulticopterFlashTool.VERSION + "</H2></HTML>");
                title.setHorizontalAlignment(0);
                String licenseText = null;
                try {
                    File licenseFile = new File("license.txt");
                    if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                        String path = System.getProperty("java.library.path");
                        path = path.substring(0, path.indexOf(":"));
                        licenseFile = new File(path, "license.txt");
                    }
                    FileInputStream licenseIS = new FileInputStream(licenseFile);
                    StringBuilder text = new StringBuilder();
                    String NL = System.getProperty("line.separator");
                    Scanner scanner = new Scanner(licenseIS);
                    while (scanner.hasNextLine()) {
                        text.append(String.valueOf(scanner.nextLine()) + NL);
                    }
                    licenseText = text.toString();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                JTextArea license = new JTextArea(licenseText);
                JScrollPane main = new JScrollPane(license);
                JDialog about = new JDialog(kkMenu.this.parent);
                about.setIconImage(Icons.getIcon("KK.png").getImage());
                about.add((Component)title, "North");
                about.add((Component)main, "Center");
                about.setSize(new Dimension(540, 400));
                about.setLocationRelativeTo(kkMenu.this.parent);
                about.setVisible(true);
            }
        });
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel icon = new JLabel(Icons.getIcon("KK.png", 192));
                JLabel title = new JLabel("<HTML><H2>KKmulticopter Flash Tool " + KKMulticopterFlashTool.VERSION + "</H2></HTML>");
                title.setHorizontalAlignment(0);
                JLabel main = new JLabel(Translatrix.getTranslationString("about.message"));
                main.setHorizontalAlignment(0);
                JDialog about = new JDialog(kkMenu.this.parent);
                about.setIconImage(Icons.getIcon("KK.png").getImage());
                about.add((Component)title, "North");
                about.add((Component)icon, "West");
                about.add((Component)main, "Center");
                about.setSize(new Dimension(480, 240));
                about.setLocationRelativeTo(kkMenu.this.parent);
                about.setVisible(true);
            }
        });
    }

    private void initSetupMenu() {
        this.setup = new JMenu(Translatrix._("settings"));
        final JCheckBoxMenuItem offlineMenuItem = new JCheckBoxMenuItem(Translatrix._("settings.offline"));
        offlineMenuItem.setSelected(KKMulticopterFlashTool.isOfflineMode());
        this.setup.add(offlineMenuItem);
        JMenuItem offlineDownloadMenuItem = new JMenuItem(Translatrix._("settings.downloadoffline"));
        this.setup.add(offlineDownloadMenuItem);
        this.setup.addSeparator();
        final JCheckBoxMenuItem enableVerboseOutputMenuItem = new JCheckBoxMenuItem(Translatrix._("settings.enableverbose"));
        enableVerboseOutputMenuItem.setSelected(KKMulticopterFlashTool.isVerboseEnabled());
        this.setup.add(enableVerboseOutputMenuItem);
        this.setup.addSeparator();
        final JCheckBoxMenuItem enablePopupMenuItem = new JCheckBoxMenuItem(Translatrix._("settings.enablepopup"));
        enablePopupMenuItem.setSelected(KKMulticopterFlashTool.isPopupsEnabled());
        this.setup.add(enablePopupMenuItem);
        final JCheckBoxMenuItem enableHideDepricatedMenuItem = new JCheckBoxMenuItem(Translatrix._("settings.hidedeprecated"));
        enableHideDepricatedMenuItem.setSelected(KKMulticopterFlashTool.isHideDecprecatedEnabled());
        this.setup.add(enableHideDepricatedMenuItem);
        final JCheckBoxMenuItem enableShowDailyTGYMenuItem = new JCheckBoxMenuItem(Translatrix._("settings.showDailyTGY"));
        enableShowDailyTGYMenuItem.setSelected(KKMulticopterFlashTool.isShowDailyTGYEnabled());
        this.setup.add(enableShowDailyTGYMenuItem);
        this.countdown = new JNamedIntMenuItem(Translatrix._("settings.countdown"), new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                KKMulticopterFlashTool.setCountdown(kkMenu.this.countdown.getValue());
            }

            @Override
            public void focusGained(FocusEvent e) {
                KKMulticopterFlashTool.setCountdown(kkMenu.this.countdown.getValue());
            }
        });
        this.countdown.setValue(KKMulticopterFlashTool.getCountdown());
        this.setup.add(this.countdown);
        this.setup.addSeparator();
        JMenu langSubMenu = new JMenu(Translatrix._("settings.language"));
        langSubMenu.setMnemonic(Translatrix._("settings.language.key").charAt(0));
        langSubMenu.setIcon(Icons.getIcon22("babelfish.png"));
        this.setup.add(langSubMenu);
        this.createLanguageMenuItem("settings.language.english", "en", "US", Locale.US, "gb.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.french", "fr", "FR", Locale.FRANCE, "fr.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.german", "de", "DE", Locale.GERMANY, "de.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.italian", "it", "IT", Locale.ITALY, "it.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.dutch", "nl", "NL", null, "nl.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.chinese", "zh", "CN", null, "cn.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.turkish", "tr", "TR", null, "tr.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.faroese", "fo", "FO", null, "fo.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.danish", "da", "DK", null, "dk.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.swedish", "se", "SE", null, "se.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.finnish", "fi", "FI", null, "fi.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.brazilian", "pt", "BR", null, "br.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.polish", "pl", "PL", null, "pl.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.spanish", "es", "ES", null, "es.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.russian", "ru", "RU", null, "ru.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.portugese", "pt", "PT", null, "pt.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.korean", "kr", "KR", null, "kr.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.slovakian", "sk", "SK", null, "sk.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.czech", "cz", "CZ", null, "cz.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.hebrew", "iw", "IL", null, "il.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.croatian", "hr", "HR", null, "hr.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.greek", "gr", "GR", null, "gr.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.romanian", "ro", "RO", null, "ro.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.norwegian", "no", "NO", null, "no.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.slovenian", "sl", "SI", null, "si.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.japanese", "ja", "JP", null, "jp.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.hungarian", "hu", "HU", null, "hu.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.bosnian", "bs", "BA", null, "ba.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.serbian", "cs", "SR", null, "serbia.png", langSubMenu);
        this.createLanguageMenuItem("settings.language.bulgarian", "bg", "BG", null, "bg.png", langSubMenu);
        offlineMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (offlineMenuItem.isSelected()) {
                    KKMulticopterFlashTool.setOfflineMode(true);
                } else {
                    KKMulticopterFlashTool.setOfflineMode(false);
                }
                kkMenu.this.parent.firePropertyChange("changed", 0L, 1L);
            }
        });
        enableVerboseOutputMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (enableVerboseOutputMenuItem.isSelected()) {
                    KKMulticopterFlashTool.setVerboseEnabled(true);
                } else {
                    KKMulticopterFlashTool.setVerboseEnabled(false);
                }
            }
        });
        enablePopupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (enablePopupMenuItem.isSelected()) {
                    KKMulticopterFlashTool.setPopupEnabled(true);
                } else {
                    KKMulticopterFlashTool.setPopupEnabled(false);
                }
            }
        });
        enableHideDepricatedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                kkMenu.this.parent.firePropertyChange("controllerChanged", 0L, 1L);
                if (enableHideDepricatedMenuItem.isSelected()) {
                    KKMulticopterFlashTool.setHideDeprecatedEnabled(true);
                } else {
                    KKMulticopterFlashTool.setHideDeprecatedEnabled(false);
                }
            }
        });
        enableShowDailyTGYMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                kkMenu.this.parent.firePropertyChange("controllerChanged", 0L, 1L);
                if (enableShowDailyTGYMenuItem.isSelected()) {
                    KKMulticopterFlashTool.setShowDailyTGYEnabled(true);
                } else {
                    KKMulticopterFlashTool.setShowDailyTGYEnabled(false);
                }
            }
        });
        offlineDownloadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirmwareDownloadFrame fdf = new FirmwareDownloadFrame(kkMenu.this.parent.getFirmwares());
            }
        });
    }

    private void createLanguageMenuItem(String menuItemString, final String isoLanguage, final String isoCountry, final Locale locale, String icon, JMenu langSubMenu) {
        String defaultString;
        String localisedString = Translatrix._(menuItemString);
        JMenuItem mi = new JMenuItem(localisedString.equals(defaultString = Translatrix.getDefaultString(menuItemString)) ? localisedString : String.valueOf(localisedString) + " (" + defaultString + ")");
        mi.setMnemonic(Translatrix._(String.valueOf(menuItemString) + ".key").charAt(0));
        mi.setIcon(Icons.getIconFlag(icon));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!kkMenu.this.parent.getLocale().equals(locale == null ? new Locale(isoLanguage, isoCountry) : locale)) {
                    kkMenu.this.parent.setLocale(isoLanguage, isoCountry);
                    if (kkMenu.this.parent.restart()) {
                        System.exit(0);
                    }
                }
            }
        });
        langSubMenu.add(mi);
    }

    public static void openURL(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }
}

