/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import avr8_burn_o_mat.XmlUtil;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lu.tudor.santec.i18n.Translatrix;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlReaderFirmwares {
    private Vector<Firmware> firmwares = new Vector();
    private double actualVersion;
    private LinkedHashMap<String, String> firmwareRepositories = new LinkedHashMap();
    private Logger logger = KKMulticopterFlashTool.getLogger();
    private String changelog;

    public XmlReaderFirmwares() {
    }

    public XmlReaderFirmwares(LinkedHashMap<String, String> firmwareRepositories) {
        this.firmwares.removeAllElements();
        if (KKMulticopterFlashTool.isOfflineMode()) {
            String url = "file://" + KKMulticopterFlashTool.getTempFolder() + "firmwares.xml";
            this.firmwareRepositories.put("", url);
            try {
                this.readXmlFile(url);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, Translatrix._("error.offlineRepository"));
                e.printStackTrace();
                this.logger.log(Level.WARNING, e.getMessage());
            }
        } else {
            this.firmwareRepositories = firmwareRepositories;
            try {
                for (String key : firmwareRepositories.keySet()) {
                    boolean load = false;
                    load = key.equals("tgydaily") ? KKMulticopterFlashTool.isShowDailyTGYEnabled() : true;
                    if (!load) continue;
                    String url = firmwareRepositories.get(key);
                    System.out.println("repository URL: " + url);
                    this.downloadFirmwareDescription(new URL(url));
                    this.readXmlFile(this.getLocalXMLFile(url.substring(url.lastIndexOf(47) + 1)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Vector<Firmware> getFirmwares() {
        return this.firmwares;
    }

    public Vector<Firmware> getFirmwares(String controllerName) {
        System.out.println("Adding firmwares for controller: " + controllerName);
        if (controllerName.endsWith("p")) {
            controllerName = controllerName.replace("p", "");
            System.out.println(controllerName);
        } else if (controllerName.endsWith("pa")) {
            controllerName = controllerName.replace("pa", "");
            System.out.println(controllerName);
        }
        Vector<Firmware> fw = new Vector<Firmware>();
        Enumeration<Firmware> en = this.firmwares.elements();
        while (en.hasMoreElements()) {
            Firmware firmware = en.nextElement();
            if (!firmware.getController().contains(controllerName)) continue;
            if (KKMulticopterFlashTool.isHideDecprecatedEnabled()) {
                if (firmware.isDeprecated()) continue;
                fw.add(firmware);
                System.out.println("add firmware to drop down list " + firmware);
                continue;
            }
            fw.add(firmware);
            System.out.println("add firmware to drop down list " + firmware);
        }
        Collections.sort(fw, new Comparator<Firmware>(){

            @Override
            public int compare(Firmware o1, Firmware o2) {
                return o2.toStringSorting().compareTo(o1.toStringSorting());
            }
        });
        return fw;
    }

    public void readXmlFile(String uri) throws Exception {
        if (!KKMulticopterFlashTool.isOfflineMode()) {
            try {
                URL url = new URL(uri);
                if (uri.startsWith("http")) {
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(5000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Level.WARNING, e.getMessage());
                throw e;
            }
        }
        System.out.println("start to parse: " + uri);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(uri);
        Node node = document.getDocumentElement().getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals("firmware")) {
                this.readFirmware(node);
            }
            if (node.getNodeName().equals("version")) {
                this.readVersion(node);
                this.readChangelog(node);
            }
            node = node.getNextSibling();
        }
    }

    private void readChangelog(Node node) {
        Node nodeChangelog = node.getFirstChild();
        this.changelog = "<ul>";
        while (nodeChangelog != null) {
            if (nodeChangelog.getNodeName().equals("change")) {
                String line = XmlUtil.getAttr(nodeChangelog, "value");
                this.changelog = this.changelog.concat("<li>" + line + "</li>");
            }
            nodeChangelog = nodeChangelog.getNextSibling();
        }
        this.changelog = this.changelog.concat("<li>and more...</li>");
        this.changelog = this.changelog.concat("</ul>");
    }

    private void readVersion(Node node) {
        this.actualVersion = Double.parseDouble(XmlUtil.getAttr(node, "name"));
    }

    private void readFirmware(Node node) throws Exception {
        Node nodeFirmware = node.getFirstChild();
        String author = new String();
        String versionname = new String();
        String controller = new String();
        String md5 = new String();
        String eepromMd5 = new String();
        String additionalOptions = new String();
        String server = new String();
        URL url = null;
        URL zipurl = null;
        URL eepromUrl = null;
        URL eepromZipurl = null;
        String svnUrl = null;
        String svnEEpromUrl = null;
        String svnName = null;
        String svnEEpromName = null;
        URL commenturl = null;
        int features = -1;
        int target = 0;
        String name = XmlUtil.getAttr(node, "name");
        String version = XmlUtil.getAttr(node, "value");
        boolean isDeprecated = false;
        while (nodeFirmware != null) {
            if (nodeFirmware.getNodeName().equals("author")) {
                author = XmlUtil.getAttr(nodeFirmware, "name");
            }
            if (nodeFirmware.getNodeName().equals("versionname")) {
                versionname = XmlUtil.getAttr(nodeFirmware, "name");
            }
            if (nodeFirmware.getNodeName().equals("controller")) {
                controller = XmlUtil.getAttr(nodeFirmware, "name");
            }
            try {
                if (nodeFirmware.getNodeName().equals("controller")) {
                    target = Integer.parseInt(XmlUtil.getAttr(nodeFirmware, "target"));
                }
            }
            catch (Exception e) {
                target = 0;
            }
            if (nodeFirmware.getNodeName().equals("file")) {
                url = new URL(XmlUtil.getAttr(nodeFirmware, "url"));
            }
            try {
                if (nodeFirmware.getNodeName().equals("zipfile")) {
                    zipurl = new URL(XmlUtil.getAttr(nodeFirmware, "url"));
                }
            }
            catch (Exception e) {
                zipurl = null;
            }
            if (nodeFirmware.getNodeName().equals("eepromfile")) {
                eepromUrl = new URL(XmlUtil.getAttr(nodeFirmware, "url"));
            }
            try {
                if (nodeFirmware.getNodeName().equals("eepromzipfile")) {
                    eepromZipurl = new URL(XmlUtil.getAttr(nodeFirmware, "url"));
                }
            }
            catch (Exception e) {
                eepromZipurl = null;
            }
            try {
                if (nodeFirmware.getNodeName().equals("svn")) {
                    svnUrl = new String(XmlUtil.getAttr(nodeFirmware, "url"));
                    svnName = new String(XmlUtil.getAttr(nodeFirmware, "name"));
                }
            }
            catch (Exception e) {
                svnUrl = null;
                svnName = null;
            }
            try {
                if (nodeFirmware.getNodeName().equals("svn")) {
                    svnEEpromUrl = new String(XmlUtil.getAttr(nodeFirmware, "eepromurl"));
                    svnEEpromName = new String(XmlUtil.getAttr(nodeFirmware, "eepromname"));
                }
            }
            catch (Exception e) {
                svnEEpromUrl = null;
                svnEEpromName = null;
            }
            try {
                if (nodeFirmware.getNodeName().equals("commenturl")) {
                    commenturl = new URL(XmlUtil.getAttr(nodeFirmware, "url"));
                }
            }
            catch (Exception e) {
                commenturl = null;
            }
            try {
                if (nodeFirmware.getNodeName().equals("additionalOptions")) {
                    additionalOptions = XmlUtil.getAttr(nodeFirmware, "option");
                }
            }
            catch (Exception e) {
                additionalOptions = new String();
            }
            if (nodeFirmware.getNodeName().equals("md5")) {
                md5 = new String(XmlUtil.getAttr(nodeFirmware, "value"));
            }
            if (nodeFirmware.getNodeName().equals("eeprommd5")) {
                eepromMd5 = new String(XmlUtil.getAttr(nodeFirmware, "value"));
            }
            if (nodeFirmware.getNodeName().equals("features")) {
                features = Integer.parseInt(XmlUtil.getAttr(nodeFirmware, "value"));
            }
            if (nodeFirmware.getNodeName().equals("server")) {
                server = new String(XmlUtil.getAttr(nodeFirmware, "name"));
            }
            if (nodeFirmware.getNodeName().equals("deprecated")) {
                isDeprecated = Boolean.parseBoolean(XmlUtil.getAttr(nodeFirmware, "value"));
            }
            nodeFirmware = nodeFirmware.getNextSibling();
        }
        Firmware firmware = new Firmware(url);
        firmware.setName(name);
        firmware.setFileName(url.toString());
        firmware.setVersionName(versionname);
        firmware.setVersion(version);
        firmware.setController(controller);
        firmware.setAuthor(author);
        firmware.setZipURL(zipurl);
        firmware.setEEpromURL(eepromUrl);
        firmware.setEEpromZipURL(eepromZipurl);
        firmware.setSVN(svnUrl);
        firmware.setSVNname(svnName);
        firmware.setEEpromSVN(svnEEpromUrl);
        firmware.setEEpromSVNname(svnEEpromName);
        firmware.setMD5(md5);
        firmware.setEEpromMD5(eepromMd5);
        firmware.setCommentURL(commenturl);
        firmware.setAdditionalOptions(additionalOptions);
        firmware.setFeatures(features);
        firmware.setTargetPlatform(target);
        firmware.setServer(server);
        firmware.setDeprecated(isDeprecated);
        this.firmwares.add(firmware);
    }

    private File downloadFirmwareDescription(URL url) {
        long time;
        String filename = null;
        String tmpdir = null;
        String urlPath = url.getPath();
        filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
        System.out.println("Download firmware description file: " + filename);
        System.out.println("from: " + url);
        tmpdir = KKMulticopterFlashTool.getTempFolder();
        filename = String.valueOf(tmpdir) + filename;
        File tmpFile = new File(filename);
        if (new File(tmpdir).mkdir()) {
            System.out.println("tmpdir created");
        }
        try {
            time = System.currentTimeMillis();
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            FileOutputStream fos = new FileOutputStream(tmpFile);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            int x = 0;
            while ((x = in.read(data, 0, 1024)) >= 0) {
                bout.write(data, 0, x);
            }
            bout.close();
            in.close();
            System.out.println("Download finished in milli seconds " + (System.currentTimeMillis() - time));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            time = System.currentTimeMillis();
            int BUFFER = 2048;
            BufferedOutputStream dest = null;
            BufferedInputStream is = null;
            ZipFile zipfile = new ZipFile(filename);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            System.out.println("zip: " + e.hasMoreElements());
            while (e.hasMoreElements()) {
                int count;
                ZipEntry entry = e.nextElement();
                System.out.println("Extracting: " + entry);
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(filename.replace(".zip", ""));
                dest = new BufferedOutputStream(fos, BUFFER);
                while ((count = is.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            System.out.println("Download extracted in milli seconds " + (System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Download finished: " + filename);
        return tmpFile;
    }

    public static void main(String[] args) {
        XmlReaderFirmwares f = new XmlReaderFirmwares();
        try {
            f.readXmlFile("./firmwares.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LinkedHashMap<String, String> getURL() {
        return this.firmwareRepositories;
    }

    public double getActualVersion() {
        return this.actualVersion;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public void reloadXmlFile(LinkedHashMap<String, String> urls) throws Exception {
        this.firmwareRepositories = urls;
        this.firmwares.removeAllElements();
        for (String key : this.firmwareRepositories.keySet()) {
            String url = this.firmwareRepositories.get(key);
            boolean load = false;
            load = key.equals("tgydaily") ? KKMulticopterFlashTool.isShowDailyTGYEnabled() : true;
            if (!load) continue;
            this.downloadFirmwareDescription(new URL(url));
            String uri = this.getLocalXMLFile(url.substring(url.lastIndexOf(47) + 1));
            this.readXmlFile(uri);
        }
    }

    private String getLocalXMLFile(String file) {
        String url = file.substring(0, file.length() - 4);
        String uri = String.valueOf(KKMulticopterFlashTool.getTempFolder()) + url;
        uri = "file:////".concat(uri);
        return uri;
    }
}

