/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils.avra;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.avra.AvraCommandLine;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.commons.io.FileUtils;

public class SimonKAvraCommandLine
extends AvraCommandLine {
    private File targetFile;

    public SimonKAvraCommandLine(String target, File workingDir) {
        super(target, workingDir);
        this.createWorkingCopy();
    }

    private void createWorkingCopy() {
        File source = new File(this.getWorkingDir().getPath(), "tgy.asm");
        KKMulticopterFlashTool.getInstance().println("source: " + source.getAbsolutePath());
        this.targetFile = new File(this.getWorkingDir().getPath(), String.valueOf(this.getTarget()) + ".asm");
        try {
            FileUtils.copyFile((File)source, (File)this.targetFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clean() throws IOException {
        FileUtils.deleteQuietly((File)this.targetFile);
        FileUtils.deleteQuietly((File)new File(this.getWorkingDir().getPath(), String.valueOf(this.getTarget()) + ".cof"));
    }

    @Override
    public Vector<String> getCommandLine() {
        Vector<String> cmd = new Vector<String>();
        cmd.add(super.getAvra());
        cmd.add("-fI");
        cmd.add("-o");
        cmd.add(this.getTarget());
        cmd.add("-D");
        cmd.add(String.valueOf(this.getTarget()) + "_esc");
        cmd.add("-e");
        cmd.add(String.valueOf(this.getTarget()) + ".eeprom");
        cmd.add("-d");
        cmd.add(String.valueOf(this.getTarget()) + ".obj");
        cmd.add(String.valueOf(this.getTarget()) + ".asm");
        return cmd;
    }

    @Override
    public File getHexFile() throws IOException {
        return new File(this.getWorkingDir().getPath(), String.valueOf(this.getTarget()) + ".hex");
    }
}

