/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class AbstractFileFinder {
    protected URL abstractDirectory;
    protected HTMLDirectoryParser htmlDirectoryParser;
    protected Map directoryMap;
    protected TreeSet directorySet;

    public URL getAbstractDirectory() {
        return this.abstractDirectory;
    }

    protected void addDirectorySetEntry(String entryName, URL url) {
        File entryFile = new File(entryName);
        String parentPath = entryFile.getParent();
        parentPath = parentPath == null ? "" : String.valueOf(parentPath) + "/";
        parentPath = parentPath.replace(File.separatorChar, '/');
        String key = "jar:" + url.getFile() + parentPath;
        TreeSet set = this.findDirectorySet(key, url);
        set.add(entryFile);
        File file = new File(parentPath);
        entryName = file.getParent();
        if (entryName != null) {
            this.addDirectorySetEntry(String.valueOf(entryName) + "/", url);
        }
    }

    protected TreeSet findDirectorySet(String key, URL url) {
        TreeSet set = (TreeSet)this.directoryMap.get(key);
        if (set == null) {
            set = new TreeSet();
            this.directoryMap.put(key, set);
        }
        return set;
    }

    protected TreeSet initializeDirectorySet(URL url) {
        TreeSet set = (TreeSet)this.directoryMap.get(url.toString());
        if (set == null) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                JarFile jarFile = jarConnection.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String entryName = jarEntry.getName();
                    this.addDirectorySetEntry(entryName, url);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            set = (TreeSet)this.directoryMap.get(url.toString());
        }
        return set;
    }

    public void setAbstractDirectory(URL url) {
        this.abstractDirectory = url;
        if (this.abstractDirectory.getProtocol().toLowerCase().equals("http")) {
            this.htmlDirectoryParser = new HTMLDirectoryParser(this.abstractDirectory);
        }
        if (this.abstractDirectory.getProtocol().toLowerCase().equals("jar")) {
            this.directorySet = this.initializeDirectorySet(this.abstractDirectory);
        }
    }

    public void setDirectoryMap(Map map) {
        this.directoryMap = map;
    }

    public void collectEntries(String dirName, List entries) {
        if (this.abstractDirectory.getProtocol().toLowerCase().equals("http")) {
            this.collectWebEntries(dirName, entries);
        }
        if (this.abstractDirectory.getProtocol().toLowerCase().equals("jar")) {
            this.collectJarEntries(dirName, entries);
        }
    }

    public void collectJarEntries(String dirName, List entries) {
        String key = "jar:" + this.abstractDirectory.getFile() + dirName;
        this.directorySet = (TreeSet)this.directoryMap.get(key);
        for (File entryFile : this.directorySet) {
            String entryName = entryFile.getName();
            if (this.directoryMap.get(String.valueOf(key) + entryName + "/") != null) {
                entryName = String.valueOf(entryName) + "/";
            }
            entries.add(entryName);
        }
    }

    public void collectWebEntries(String dirName, List entries) {
        this.htmlDirectoryParser.parse(dirName);
        List tagList = this.htmlDirectoryParser.getEntries();
        int i = 0;
        while (i < tagList.size()) {
            block5: {
                String href = (String)tagList.get(i);
                if (!href.startsWith("/") && !href.startsWith("?")) {
                    try {
                        URI uri = new URI(href);
                        if (uri.isAbsolute()) {
                        }
                    }
                    catch (URISyntaxException e) {}
                    break block5;
                    entries.add(href);
                }
            }
            ++i;
        }
    }

    class HTMLDirectoryParser
    extends HTMLEditorKit {
        protected URL base;
        protected HTMLEditorKit.Parser parser;
        protected Callback callback;

        public HTMLDirectoryParser(URL url) {
            this.base = url;
            this.parser = this.getParser();
            this.callback = new Callback();
        }

        protected Reader getURLReader(String dir) {
            InputStreamReader reader = null;
            try {
                URL url = new URL(AbstractFileFinder.this.abstractDirectory, dir);
                reader = new InputStreamReader(url.openStream());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return reader;
        }

        public void parse(String dirName) {
            try {
                this.callback.clearEntries();
                this.parser.parse(this.getURLReader(dirName), this.callback, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public List getEntries() {
            return this.callback.getEntries();
        }

        class Callback
        extends HTMLEditorKit.ParserCallback {
            protected List entries = new Vector();
            protected Stack attributeStack = new Stack();

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                super.handleStartTag(t, a, pos);
                if (t == HTML.Tag.A) {
                    String href = (String)a.getAttribute(HTML.Attribute.HREF);
                    this.entries.add(href);
                }
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
            }

            public void clearEntries() {
                this.entries.clear();
            }

            public List getEntries() {
                return this.entries;
            }
        }
    }
}

