/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.io.File;
import javax.swing.filechooser.FileFilter;

class ImageFileFilter
extends FileFilter {
    String fileUpperType;
    String fileType;
    String fileExtension;

    ImageFileFilter(String fileType) {
        this.fileType = fileType;
        this.fileUpperType = this.fileType.toUpperCase();
        this.fileExtension = "." + fileType;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String str = f.getName().toUpperCase();
        if (str.endsWith(this.fileExtension.toUpperCase())) {
            return true;
        }
        if (this.fileUpperType.equals("JPG") || this.fileUpperType.equals("JPEG")) {
            return str.endsWith(".JPG") || str.endsWith(".JPEG");
        }
        return false;
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.fileUpperType) + " images";
    }
}

