/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.concord.swing.Selectable;
import org.concord.swing.SelectableContainer;

public class SelectableItem
implements Selectable {
    protected Component componentItem;
    protected Boundary boundary = new Boundary(this);
    protected boolean selected = false;
    protected SelectableContainer container;
    protected Color defaultColor = Color.BLACK;
    protected Color activeColor = Color.RED;

    public SelectableItem(SelectableContainer container) {
        this.container = container;
    }

    public void draw(Graphics g) {
        this.boundary.draw(g);
    }

    @Override
    public Component getComponent() {
        return this.componentItem;
    }

    public void setComponent(Component item) {
        this.componentItem = item;
        if (this.componentItem != null) {
            this.boundary.setBounds(item.getBounds());
        }
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean value) {
        this.selected = value;
    }

    @Override
    public void toggleSelected() {
    }

    @Override
    public boolean contains(int x, int y) {
        return this.boundary.contains(x, y);
    }

    @Override
    public boolean isActive() {
        return this.container.getActiveObject() == this;
    }

    public class Boundary
    extends Rectangle {
        protected int handleWidth = 6;
        protected int handleHeight = 6;
        protected Handle[] handles = new Handle[9];
        protected Selectable parent;
        private Handle selectedHandle;

        public Boundary(Selectable selectable) {
            this.parent = selectable;
        }

        @Override
        public void setBounds(Rectangle b) {
            this.setBounds(b.x, b.y, b.width, b.height);
        }

        public void setHandleSize(int width, int height) {
            this.handleWidth = width;
            this.handleHeight = height;
            int i = 0;
            while (i < this.handles.length) {
                if (this.handles[i] == null) {
                    this.handles[i] = new Handle(this, i, this.handleWidth, this.handleHeight);
                } else {
                    this.handles[i].setSize(this.handleWidth, this.handleHeight);
                }
                ++i;
            }
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            SelectableItem.this.componentItem.setBounds(x, y, width, height);
            super.setBounds(--x, --y, ++width, ++height);
            this.setHandleSize(this.handleWidth, this.handleHeight);
            int i = 0;
            while (i < this.handles.length) {
                this.handles[i].setHandleBounds(x, y, width, height);
                ++i;
            }
        }

        @Override
        public Rectangle getBounds() {
            return SelectableItem.this.componentItem.getBounds();
        }

        @Override
        public Point getLocation() {
            return SelectableItem.this.componentItem.getLocation();
        }

        @Override
        public void setLocation(int x, int y) {
            Dimension size = this.getSize();
            this.setBounds(x, y, size.width, size.height);
        }

        @Override
        public void setLocation(Point location) {
            this.setLocation(location.x, location.y);
        }

        @Override
        public Dimension getSize() {
            return SelectableItem.this.componentItem.getSize();
        }

        @Override
        public void setSize(int width, int height) {
            Point location = this.getLocation();
            this.setBounds(location.x, location.y, width, height);
        }

        @Override
        public void setSize(Dimension size) {
            this.setSize(size.width, size.height);
        }

        public Handle getSelectedHandle() {
            return this.selectedHandle;
        }

        public Selectable getParent() {
            return this.parent;
        }

        public Handle findHandle(int x, int y) {
            int i = 0;
            while (i < this.handles.length) {
                if (this.handles[i].contains(x, y)) {
                    return this.handles[i];
                }
                ++i;
            }
            return null;
        }

        @Override
        public boolean contains(int x, int y) {
            this.selectedHandle = this.findHandle(x, y);
            return this.selectedHandle instanceof Handle;
        }

        public void draw(Graphics g) {
            if (this.parent.isActive()) {
                g.setColor(SelectableItem.this.activeColor);
            }
            g.drawRect(this.x, this.y, this.width, this.height);
            if (this.parent.isSelected()) {
                int i = 0;
                while (i < this.handles.length) {
                    Rectangle b = this.handles[i];
                    if (i == 8) {
                        b = this.handles[i].dragBounds;
                        g.drawRect(b.x, b.y, b.width, b.height);
                    } else {
                        g.fillRect(b.x, b.y, b.width, b.height);
                    }
                    ++i;
                }
            }
            g.setColor(SelectableItem.this.defaultColor);
        }
    }

    public class Handle
    extends Rectangle {
        public static final int TOP_LEFT = 0;
        public static final int TOP_MIDDLE = 1;
        public static final int TOP_RIGHT = 2;
        public static final int MIDDLE_RIGHT = 3;
        public static final int BOTTOM_RIGHT = 4;
        public static final int BOTTOM_MIDDLE = 5;
        public static final int BOTTOM_LEFT = 6;
        public static final int MIDDLE_LEFT = 7;
        public static final int DRAG = 8;
        public static final int HANDLE_WIDTH = 6;
        public static final int HANDLE_HEIGHT = 6;
        public static final int MIN_WIDTH = 4;
        public static final int MIN_HEIGHT = 4;
        public final Rectangle[] scaleFactors = new Rectangle[]{new Rectangle(1, 1, -1, -1), new Rectangle(0, 1, 0, -1), new Rectangle(0, 1, 1, -1), new Rectangle(0, 0, 1, 0), new Rectangle(0, 0, 1, 1), new Rectangle(0, 0, 0, 1), new Rectangle(1, 0, -1, 1), new Rectangle(1, 0, -1, 0), new Rectangle(1, 1, 1, 1)};
        protected Rectangle factors;
        protected int position = -1;
        protected Boundary parent;
        protected Rectangle dragBounds = new Rectangle();

        public Handle(Boundary parent, int position, int w, int h) {
            this.width = w;
            this.height = h;
            this.position = position;
            this.parent = parent;
            this.factors = this.scaleFactors[position];
        }

        public void scale(int dx, int dy) {
            Rectangle b = SelectableItem.this.boundary.getBounds();
            b.width += this.factors.width * dx;
            b.height += this.factors.height * dy;
            if (b.width < 4) {
                b.width = 4;
            } else {
                b.x += this.factors.x * dx;
            }
            if (b.height < 4) {
                b.height = 4;
            } else {
                b.y += this.factors.y * dy;
            }
            SelectableItem.this.boundary.setBounds(b.x, b.y, b.width, b.height);
        }

        public void setHandleBounds(int x, int y, int w, int h) {
            switch (this.position) {
                case 0: {
                    this.x = x - this.width - 1;
                    this.y = y - this.height - 1;
                    break;
                }
                case 1: {
                    this.x = x + w / 2 + 1 - this.width / 2;
                    this.y = y - this.height - 1;
                    break;
                }
                case 2: {
                    this.x = x + w + 2;
                    this.y = y - this.height - 1;
                    break;
                }
                case 3: {
                    this.x = x + w + 2;
                    this.y = y + h / 2 + 1 - this.height / 2;
                    break;
                }
                case 4: {
                    this.x = x + w + 2;
                    this.y = y + h + 2;
                    break;
                }
                case 5: {
                    this.x = x + w / 2 + 1 - this.width / 2;
                    this.y = y + h + 2;
                    break;
                }
                case 6: {
                    this.x = x - this.width - 1;
                    this.y = y + h + 2;
                    break;
                }
                case 7: {
                    this.x = x - this.width - 1;
                    this.y = y + h / 2 + 1 - this.height / 2;
                    break;
                }
                case 8: {
                    this.dragBounds.x = x - this.width - 1;
                    this.dragBounds.y = y - this.height - 1;
                    this.dragBounds.width = w + 2 * this.width + 2;
                    this.dragBounds.height = h + 2 * this.height + 2;
                }
            }
        }

        @Override
        public boolean contains(int x, int y) {
            if (this.position == 8) {
                return this.dragBounds.contains(x, y);
            }
            return super.contains(x, y);
        }

        public int getPosition() {
            return this.position;
        }
    }
}

