/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Vector;
import org.concord.swing.RecordBuffer;

public class StreamRecord {
    protected int bufferSize;
    protected HashMap streamTable = new HashMap();
    protected HashMap bufferTable = new HashMap();
    protected Vector listeners = new Vector();

    public StreamRecord(int size) {
        this.bufferSize = size;
    }

    protected Object createStream(Object stream, RecordStream recordStream) {
        if (stream instanceof InputStream || stream instanceof OutputStream) {
            Class[] parameterTypes = new Class[]{stream instanceof InputStream ? InputStream.class : OutputStream.class};
            Class<?> streamClass = stream.getClass();
            try {
                Object[] parameters = new Object[]{recordStream};
                Constructor<?> constructor = streamClass.getConstructor(parameterTypes);
                Object resultStream = constructor.newInstance(parameters);
                if (resultStream != null) {
                    this.streamTable.put(recordStream, stream);
                    this.bufferTable.put(resultStream, recordStream);
                }
                return resultStream;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected RecordStream createRecordStream(Object stream, RecordBuffer buffer) {
        RecordStream recordStream = null;
        if (stream instanceof OutputStream) {
            recordStream = new RecordOutputStream((OutputStream)stream, buffer);
        } else if (stream instanceof InputStream) {
            recordStream = new RecordInputStream((InputStream)stream, buffer);
        }
        return recordStream;
    }

    protected RecordStream createRecordStream(Object stream, int bufferSize) {
        RecordStream recordStream = null;
        if (stream instanceof OutputStream) {
            recordStream = new RecordOutputStream((OutputStream)stream, bufferSize);
        } else if (stream instanceof InputStream) {
            recordStream = new RecordInputStream((InputStream)stream, bufferSize);
        }
        return recordStream;
    }

    public Object getStream(Object stream) {
        RecordStream recordStream = this.createRecordStream(stream, this.bufferSize);
        return this.createStream(stream, recordStream);
    }

    public Object getStream(Object stream, Object sharedStream) {
        if (sharedStream == null) {
            return this.getStream(stream);
        }
        RecordStream recordStream = (RecordStream)this.bufferTable.get(sharedStream);
        RecordBuffer buffer = recordStream.getRecordBuffer();
        return this.createStream(stream, this.createRecordStream(stream, buffer));
    }

    public String getText(Object stream) {
        if (stream instanceof OutputStream) {
            RecordOutputStream record = (RecordOutputStream)this.bufferTable.get(stream);
            return record.getText();
        }
        if (stream instanceof InputStream) {
            RecordInputStream record = (RecordInputStream)this.bufferTable.get(stream);
            return record.getText();
        }
        return null;
    }

    public void addRecordListener(Object stream, RecordBuffer.RecordListener listener) {
        RecordStream recordStream = (RecordStream)this.bufferTable.get(stream);
        if (listener != null && recordStream != null) {
            recordStream.getRecordBuffer().addRecordListener(listener);
        }
    }

    public void removeRecordListener(Object stream, RecordBuffer.RecordListener listener) {
        RecordStream recordStream = (RecordStream)this.bufferTable.get(stream);
        if (listener != null && recordStream != null) {
            recordStream.getRecordBuffer().removeRecordListener(listener);
        }
    }

    public static class RecordInputStream
    extends InputStream
    implements RecordStream {
        protected RecordBuffer buffer;
        protected InputStream in;

        public RecordInputStream(InputStream inputStream, int size) {
            this.buffer = new RecordBuffer(size);
            this.in = inputStream;
        }

        public RecordInputStream(InputStream inputStream, RecordBuffer shareBuffer) {
            this.buffer = shareBuffer;
            this.in = inputStream;
        }

        @Override
        public RecordBuffer getRecordBuffer() {
            return this.buffer;
        }

        @Override
        public String getText() {
            return this.buffer.getText();
        }

        @Override
        public int read() throws IOException {
            int value = this.in.read();
            this.buffer.put(value);
            return value;
        }
    }

    public static class RecordOutputStream
    extends OutputStream
    implements RecordStream {
        protected RecordBuffer buffer;
        protected OutputStream out;

        public RecordOutputStream(OutputStream outputStream, int size) {
            this.buffer = new RecordBuffer(size);
            this.out = outputStream;
        }

        public RecordOutputStream(OutputStream outputStream, RecordBuffer shareBuffer) {
            this.buffer = shareBuffer;
            this.out = outputStream;
        }

        @Override
        public RecordBuffer getRecordBuffer() {
            return this.buffer;
        }

        @Override
        public String getText() {
            return this.buffer.getText();
        }

        @Override
        public void write(int value) throws IOException {
            this.out.write(value);
            this.buffer.put(value);
        }
    }

    public static interface RecordStream {
        public String getText();

        public RecordBuffer getRecordBuffer();
    }
}

