/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.concord.swing.CCJCheckBoxRenderer;
import org.concord.swing.CCJCheckBoxTree;
import org.concord.swing.MostRecentFileDialog;
import org.concord.swing.Zipper;

public class ZipperPanel
extends JPanel {
    CCJCheckBoxTree filesTree;
    MostRecentFileDialog mrfd = new MostRecentFileDialog("org.concord.zip.file.source");
    Hashtable filesHash = new Hashtable();
    Vector filesToZip = new Vector();

    public ZipperPanel() {
        this.init();
    }

    public ZipperPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public ZipperPanel(LayoutManager layout) {
        super(layout);
        this.init();
    }

    public ZipperPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.filesTree = new CCJCheckBoxTree("Files to Zip");
        this.filesTree.setCellRenderer(new CCJCheckBoxRenderer());
        this.filesTree.setRootVisible(false);
        JScrollPane scrollPane = new JScrollPane(this.filesTree);
        this.add((Component)scrollPane, "Center");
        JButton addFile = new JButton("Add File(s)");
        addFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f;
                int retval = ZipperPanel.this.mrfd.showOpenDialog(null, "Add a file to compress");
                if (retval == 0 && (f = ZipperPanel.this.mrfd.getSelectedFile()).isFile() && !ZipperPanel.this.filesHash.contains(f.getAbsolutePath())) {
                    String fn = f.getName();
                    CCJCheckBoxTree.NodeHolder newNodeHolder = new CCJCheckBoxTree.NodeHolder(fn, true);
                    ZipperPanel.this.filesTree.addObject(newNodeHolder);
                    ZipperPanel.this.filesHash.put(newNodeHolder, f.getAbsolutePath());
                }
            }
        });
        JButton zipFile = new JButton("Zip File(s)");
        zipFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ZipperPanel.this.filesHash.isEmpty()) {
                    String msg = "No files to zip. Please add files first.";
                    JOptionPane.showMessageDialog(null, msg, "NO Files", 0);
                    return;
                }
                ZipperPanel.this.filesToZip.removeAllElements();
                Set keys = ZipperPanel.this.filesHash.keySet();
                for (CCJCheckBoxTree.NodeHolder key : keys) {
                    if (!key.checked) continue;
                    ZipperPanel.this.filesToZip.addElement(new File(ZipperPanel.this.filesHash.get(key).toString()));
                }
                if (ZipperPanel.this.filesToZip.size() == 0) {
                    String msg = "Please select the files to zip.";
                    JOptionPane.showMessageDialog(null, msg, "NO Files", 0);
                    return;
                }
                MostRecentFileDialog mrfd2 = new MostRecentFileDialog("org.concord.zip.file.target");
                int retval = mrfd2.showSaveDialog(null, "Save zipped file");
                if (retval == 0) {
                    File f = mrfd2.getSelectedFile();
                    Zipper.zip(ZipperPanel.this.filesToZip, f);
                }
            }
        });
        JPanel control = new JPanel();
        control.add(addFile);
        control.add(zipFile);
        this.add((Component)control, "South");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Zip Example");
        frame.setDefaultCloseOperation(3);
        ZipperPanel zp = new ZipperPanel();
        frame.getContentPane().add(zp);
        frame.pack();
        frame.show();
    }
}

