/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.concord.swing.graph.Gauge;
import org.concord.swing.graph.ValueGraph;

public class BarGraph
extends JComponent
implements ValueGraph {
    public static Vector oldGauges = new Vector();
    public static final int DEFAULT_GAUGE_WIDTH = 100;
    public static final int DEFAULT_NUMBER_OF_GAUGES = 5;
    protected int gaugeWidth = 100;
    protected int numberOfGauges = 5;
    protected Color background;
    protected Gauge[] gauges;
    protected boolean editable = false;
    protected Vector indexMap = new Vector();
    protected ChangeListener sliderChanged = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            if (BarGraph.this.slider instanceof JSlider) {
                BarGraph.this.setScaleMax(BarGraph.this.slider.getMaximum() - BarGraph.this.slider.getValue());
            }
            BarGraph.this.repaint();
        }
    };
    protected JSlider slider;
    protected ComponentAdapter sizeChanged = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            BarGraph.this.setBarGraphSize(BarGraph.this.getSize());
        }
    };

    public BarGraph() {
        this.setLayout(null);
        this.addComponentListener(this.sizeChanged);
        this.setNumberOfGauges(5);
        this.background = this.getBackground();
    }

    public void addMapEntry(int index, int i, int j) {
        Point point;
        if (index >= this.indexMap.size()) {
            this.indexMap.setSize(index + 1);
        }
        if ((point = (Point)this.indexMap.elementAt(index)) == null) {
            point = new Point(i, j);
            this.indexMap.setElementAt(point, index);
        } else {
            point.x = i;
            point.y = j;
        }
    }

    public void removeMapEntry(int index, int i, int j) {
        if (index < this.indexMap.size()) {
            this.indexMap.setElementAt(null, index);
        }
    }

    public void clearMap() {
        this.indexMap.removeAllElements();
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    public void setNumberOfGauges(int number) {
        int i;
        this.removeAll();
        if (this.gauges != null) {
            i = 0;
            while (i < this.gauges.length) {
                oldGauges.addElement(this.gauges[i]);
                this.gauges[i] = null;
                ++i;
            }
        }
        this.numberOfGauges = number;
        this.gauges = new Gauge[number];
        i = 0;
        while (i < number) {
            if (oldGauges.size() > 0) {
                this.gauges[i] = (Gauge)oldGauges.elementAt(0);
                oldGauges.removeElementAt(0);
            } else {
                this.gauges[i] = new Gauge();
            }
            this.add(this.gauges[i]);
            ++i;
        }
        this.setBarGraphSize(this.getSize());
    }

    public void setMax(double value) {
        int i = 0;
        while (i < this.gauges.length) {
            if (this.gauges[i] instanceof Gauge) {
                this.gauges[i].setMax(value);
            }
            ++i;
        }
    }

    public void setScaleMax(int scale) {
        double value = ((double)scale - 50.0) / 10.0;
        this.setMax(Math.pow(10.0, value));
    }

    public double getMax() {
        return this.gauges[0].getMax();
    }

    protected double log10(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    public void setSliderValue() {
        int value = (int)(10.0 * this.log10(this.getMax()) + 50.0);
        value = this.slider.getMaximum() - value;
        if (value < 0) {
            value = 0;
        }
        this.slider.setValue(value);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean value) {
        this.editable = value;
        int i = 0;
        while (i < this.numberOfGauges) {
            this.gauges[i].setEditable(value);
            ++i;
        }
    }

    public JSlider getSlider() {
        if (this.slider == null) {
            this.setSlider(new JSlider());
        }
        return this.slider;
    }

    public void setSlider(JSlider slider) {
        if (this.slider instanceof JSlider) {
            this.slider.removeChangeListener(this.sliderChanged);
        }
        this.slider = slider;
        if (this.slider instanceof JSlider) {
            this.slider.addChangeListener(this.sliderChanged);
        }
    }

    @Override
    public Color getColor(int index) {
        Point point;
        if (index < this.indexMap.size() && (point = (Point)this.indexMap.elementAt(index)) instanceof Point) {
            return this.gauges[point.x].getColor(point.y);
        }
        return this.gauges[index].getColor();
    }

    @Override
    public void setColor(Color color, int index) {
        if (index < this.indexMap.size()) {
            Point point = (Point)this.indexMap.elementAt(index);
            if (point instanceof Point) {
                this.gauges[point.x].setColor(color, point.y);
            }
        } else {
            this.gauges[index].setColor(color);
        }
        this.repaint();
    }

    public void setGaugeWidth(int width) {
        this.gaugeWidth = width;
        this.setBarGraphSize(this.getSize());
    }

    public int getGaugeWidth() {
        return this.gaugeWidth;
    }

    public Gauge getGauge(int index) {
        return this.gauges[index];
    }

    protected void setBarGraphSize(Dimension size) {
        int gaugeGap = (size.width - this.numberOfGauges * this.gaugeWidth) / (this.numberOfGauges + 1);
        int width = this.gaugeWidth;
        if (gaugeGap <= 0) {
            width = size.width / this.numberOfGauges - 1;
            gaugeGap = 1;
        }
        int i = 0;
        while (i < this.numberOfGauges) {
            this.gauges[i].setBounds((i + 1) * gaugeGap + i * width, 0, width, size.height);
            this.gauges[i].setEditable(this.editable);
            ++i;
        }
    }

    public double getValue(int index) {
        Point point;
        if (index < this.indexMap.size() && (point = (Point)this.indexMap.elementAt(index)) instanceof Point) {
            return this.gauges[point.x].getValue(point.y);
        }
        return this.gauges[index].getValue();
    }

    public double getValue() {
        return this.getValue(0);
    }

    @Override
    public void updateValue(double x, int index) {
        Point point;
        if (index < this.indexMap.size() && (point = (Point)this.indexMap.elementAt(index)) instanceof Point) {
            this.gauges[point.x].updateValue(x, point.y);
            return;
        }
        this.gauges[index].updateValue(x);
        this.repaint();
    }

    @Override
    public void updateValue(double x) {
        this.updateValue(x, 0);
    }

    @Override
    public void updateValue(float x, int index) {
        this.updateValue((double)x, index);
    }

    @Override
    public void updateValue(float x) {
        this.updateValue((double)x);
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle b = this.getBounds();
        g.setColor(this.background);
        g.fillRect(0, 0, b.width, b.height);
        super.paintComponent(g);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test bar graph");
        BarGraph barGraph = new BarGraph();
        barGraph.setBackground(Color.black);
        barGraph.setEditable(true);
        frame.getContentPane().add((Component)barGraph, "Center");
        frame.setSize(600, 500);
        frame.setVisible(true);
    }
}

