/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageObserver;
import java.util.Vector;
import javax.swing.JComponent;
import org.concord.swing.map.ArcItem;
import org.concord.swing.map.MapContainer;
import org.concord.swing.map.MapEvent;
import org.concord.swing.map.MapItem;
import org.concord.swing.map.MapItemListener;
import org.concord.swing.map.MapSelection;
import org.concord.swing.map.NodeItem;

public class MapView
extends JComponent
implements MapSelection,
ImageObserver {
    protected boolean creatingNode = false;
    protected boolean creatingArc = false;
    protected MapContainer containerItem;
    protected Dimension preferredSize = new Dimension(800, 600);
    protected Vector listeners = new Vector();
    protected Vector selected = new Vector();
    protected Vector deselected = new Vector();
    protected Rectangle selectBox = new Rectangle(0, 0, 0, 0);
    protected boolean nesting = true;
    protected boolean selecting = true;
    protected boolean moving = true;
    protected boolean inView = false;
    protected int pressedX;
    protected int pressedY;
    protected int xMove;
    protected int yMove;
    protected boolean dragged = false;
    protected boolean dragMove = false;
    protected int[] initialXArc;
    protected int[] initialYArc;
    protected int[] xArc;
    protected int[] yArc;
    protected Polygon arcPolygon;
    protected ArcItem newArc;
    protected Point arcPoint;
    protected ArcItem movingArc;
    protected final Runnable runUpdate;

    public MapView() {
        int[] nArray = new int[7];
        nArray[1] = 50;
        nArray[2] = 50;
        nArray[3] = 65;
        nArray[4] = 50;
        nArray[5] = 50;
        this.initialXArc = nArray;
        int[] nArray2 = new int[7];
        nArray2[0] = 6;
        nArray2[1] = 6;
        nArray2[3] = 8;
        nArray2[4] = 16;
        nArray2[5] = 10;
        nArray2[6] = 10;
        this.initialYArc = nArray2;
        this.xArc = new int[this.initialXArc.length];
        this.yArc = new int[this.initialYArc.length];
        this.arcPolygon = new Polygon();
        this.runUpdate = new Runnable(){

            @Override
            public void run() {
                Font font = MapView.this.getFont();
                if (MapView.this.containerItem != null && font != null) {
                    int minX = 0;
                    int minY = 0;
                    int maxX = 0;
                    int maxY = 0;
                    FontMetrics metrics = MapView.this.getFontMetrics(font);
                    Vector nodeItems = MapView.this.containerItem.getNodeItems();
                    int i = 0;
                    while (i < nodeItems.size()) {
                        NodeItem nodeItem = (NodeItem)nodeItems.elementAt(i);
                        Rectangle bounds = nodeItem.computeBounds(metrics);
                        nodeItem.setSize(bounds.getSize());
                        Rectangle b = nodeItem.getBounds();
                        minX = Math.min(minX, b.x);
                        minY = Math.min(minY, b.y);
                        maxX = Math.max(maxX, b.x + b.width);
                        maxY = Math.max(maxY, b.y + b.height);
                        MapView.this.preferredSize.width = Math.max(MapView.this.preferredSize.width, maxX - minX);
                        MapView.this.preferredSize.height = Math.max(MapView.this.preferredSize.height, maxY - minY);
                        ++i;
                    }
                    if (minX < 0 || minY < 0) {
                        int moveX = minX < 0 ? -minX : 0;
                        int moveY = minY < 0 ? -minY : 0;
                        int i2 = 0;
                        while (i2 < nodeItems.size()) {
                            NodeItem nodeItem = (NodeItem)nodeItems.elementAt(i2);
                            nodeItem.translate(moveX, moveY);
                            Rectangle b = nodeItem.getBounds();
                            MapView.this.preferredSize.width = Math.max(MapView.this.preferredSize.width, b.x + b.width);
                            MapView.this.preferredSize.height = Math.max(MapView.this.preferredSize.height, b.y + b.height);
                            ++i2;
                        }
                        Vector arcItems = MapView.this.containerItem.getArcItems();
                        int i3 = 0;
                        while (i3 < arcItems.size()) {
                            ArcItem arcItem = (ArcItem)arcItems.elementAt(i3);
                            arcItem.translate(moveX, moveY);
                            ++i3;
                        }
                    }
                }
            }
        };
        this.containerItem = new NodeItem(null, "Root");
        this.setPreferredSize(this.preferredSize);
        this.addMouseListener(new MapViewMouseAdapter());
        this.addMouseMotionListener(new MapViewMouseMotionAdapter());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateView();
    }

    public void updateView() {
        try {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this.runUpdate);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.runUpdate.run();
        this.repaint();
    }

    public void setNestingEnabled(boolean nest) {
        this.nesting = nest;
    }

    public boolean isNestingEnabled() {
        return this.nesting;
    }

    public void setSelectingEnabled(boolean select) {
        this.selecting = select;
    }

    public boolean isSelectingEnabled() {
        return this.selecting;
    }

    public void setMovingEnabled(boolean move) {
        this.moving = move;
    }

    public boolean isMovingEnabled() {
        return this.moving;
    }

    public void addMapItemListener(MapItemListener listener) {
        if (listener instanceof MapItemListener) {
            this.listeners.addElement(listener);
        }
    }

    public void removeMapItemListener(MapItemListener listener) {
        if (listener instanceof MapItemListener) {
            this.listeners.removeElement(listener);
        }
    }

    public void callMapItemListeners(Object arg, int type) {
        MapEvent event = new MapEvent(this, arg, type);
        int i = 0;
        while (i < this.listeners.size()) {
            MapItemListener listener = (MapItemListener)this.listeners.elementAt(i);
            switch (type) {
                case 0: {
                    listener.mapItemSelection(event);
                    break;
                }
                case 1: {
                    listener.mapItemMove(event);
                    break;
                }
                case 2: {
                    listener.mapItemOpen(event);
                    break;
                }
                case 3: {
                    listener.mapItemCreate(event);
                    break;
                }
                case 4: {
                    listener.mapItemDelete(event);
                    break;
                }
                case 5: {
                    listener.mapItemPopup(event);
                }
            }
            ++i;
        }
    }

    @Override
    public void setSelected(MapItem item, boolean multiple) {
        if (multiple) {
            if (this.selected.contains(item) && !this.deselected.contains(item)) {
                this.deselected.addElement(item);
            }
        } else if (!this.selected.contains(item)) {
            this.selected.removeAllElements();
        }
        if (item instanceof MapItem && !this.selected.contains(item)) {
            this.selected.addElement(item);
        }
    }

    @Override
    public void checkSelected(MapItem item, boolean multiple) {
        int i = 0;
        while (i < this.deselected.size()) {
            this.selected.removeElement(this.deselected.elementAt(i));
            ++i;
        }
        this.deselected.removeAllElements();
    }

    public void reselect() {
        this.deselected.removeAllElements();
    }

    public boolean isMultiple(MouseEvent event) {
        return event.isShiftDown();
    }

    public void setContainerItem(MapContainer item) {
        this.setContainerItem(item, true);
    }

    public void setContainerItem(MapContainer item, boolean setSelected) {
        if (item != null) {
            this.containerItem = item;
            if (setSelected) {
                this.setSelected(null, false);
            }
        }
        this.updateView();
    }

    public MapContainer getContainerItem() {
        return this.containerItem;
    }

    @Override
    public void paintComponent(Graphics g) {
        Vector nodeItems = this.containerItem.getNodeItems();
        Vector arcItems = this.containerItem.getArcItems();
        if (this.containerItem instanceof MapContainer) {
            Dimension size = this.getSize();
            g.clearRect(0, 0, size.width, size.height);
            int test = 0;
            while (test < (this.selecting ? 2 : 1)) {
                ArcItem arcItem;
                boolean drawSelected = test == 1;
                int i = 0;
                while (i < arcItems.size()) {
                    arcItem = (ArcItem)arcItems.elementAt(i);
                    if (drawSelected && this.selected.contains(arcItem)) {
                        arcItem.drawConnect(g, true);
                    } else {
                        arcItem.drawConnect(g, false);
                    }
                    ++i;
                }
                i = 0;
                while (i < nodeItems.size()) {
                    NodeItem nodeItem = (NodeItem)nodeItems.elementAt(i);
                    if (drawSelected && this.selected.contains(nodeItem)) {
                        nodeItem.draw(g, true);
                    } else {
                        nodeItem.draw(g, false);
                    }
                    ++i;
                }
                i = 0;
                while (i < arcItems.size()) {
                    arcItem = (ArcItem)arcItems.elementAt(i);
                    if (drawSelected && this.selected.contains(arcItem)) {
                        arcItem.draw(g, true);
                    } else {
                        arcItem.draw(g, false);
                    }
                    ++i;
                }
                ++test;
            }
            if (this.selecting && this.dragged && !this.dragMove) {
                g.drawRect(this.selectBox.x, this.selectBox.y, this.selectBox.width, this.selectBox.height);
            }
            if (this.creatingNode && this.inView) {
                g.setColor(Color.blue);
                g.fillOval(this.xMove - 15, this.yMove - 15, 30, 30);
                g.setColor(Color.black);
                g.drawOval(this.xMove - 15, this.yMove - 15, 30, 30);
            }
            if (this.creatingArc && this.inView) {
                g.setColor(Color.black);
                int i = 0;
                while (i < this.initialXArc.length) {
                    this.xArc[i] = this.initialXArc[i];
                    this.yArc[i] = this.initialYArc[i];
                    ++i;
                }
                this.arcPolygon.npoints = this.xArc.length;
                this.arcPolygon.xpoints = this.xArc;
                this.arcPolygon.ypoints = this.yArc;
                this.arcPolygon.translate(this.xMove - 30, this.yMove - 8);
                g.fillPolygon(this.arcPolygon);
            }
        }
    }

    protected MapItem findMapItem(int x, int y) {
        Vector[] lists = new Vector[]{this.containerItem.getArcItems(), this.containerItem.getNodeItems()};
        MapItem item = null;
        int n = 0;
        while (n < lists.length) {
            Vector items = lists[n];
            item = this.findSingleMapItem(items, x, y);
            if (item instanceof MapItem) break;
            ++n;
        }
        return item;
    }

    protected MapItem findSingleMapItem(Vector items, int x, int y) {
        int i = 0;
        while (i < items.size()) {
            ArcItem arcItem;
            MapItem item = (MapItem)items.elementAt(i);
            if (item.getBounds().contains(x, y)) {
                return item;
            }
            if (item instanceof ArcItem && ((arcItem = (ArcItem)item).isNearSourceLocation(x, y) || arcItem.isNearSinkLocation(x, y))) {
                return arcItem;
            }
            ++i;
        }
        return null;
    }

    protected NodeItem findNodeItem(int x, int y) {
        return (NodeItem)this.findSingleMapItem(this.containerItem.getNodeItems(), x, y);
    }

    protected ArcItem findArcItem(int x, int y) {
        return (ArcItem)this.findSingleMapItem(this.containerItem.getArcItems(), x, y);
    }

    protected Vector findMapItems(Rectangle box, Vector list, boolean multiple) {
        Vector[] lists = new Vector[]{this.containerItem.getNodeItems(), this.containerItem.getArcItems()};
        if (!multiple) {
            list.removeAllElements();
        }
        int n = 0;
        while (n < lists.length) {
            Vector items = lists[n];
            int i = 0;
            while (i < items.size()) {
                MapItem item = (MapItem)items.elementAt(i);
                if (item.getBounds().intersects(box)) {
                    list.addElement(item);
                }
                ++i;
            }
            ++n;
        }
        return list;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (infoflags == 32) {
            this.updateView();
            return false;
        }
        return true;
    }

    public void setCreatingNode(boolean value) {
        this.creatingNode = value;
    }

    public void setCreatingArc(boolean value) {
        this.creatingArc = value;
    }

    protected class MapViewMouseAdapter
    extends MouseAdapter {
        protected MapItem item;
        protected boolean maybePopup;

        protected MapViewMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            MapView.this.pressedX = event.getX();
            MapView.this.pressedY = event.getY();
            this.item = MapView.this.findMapItem(MapView.this.pressedX, MapView.this.pressedY);
            MapView.this.setSelected(this.item, MapView.this.isMultiple(event));
            MapView.this.selectBox.setLocation(event.getPoint());
            boolean bl = MapView.this.dragMove = MapView.this.selected.size() > 0;
            if (MapView.this.creatingNode) {
                NodeItem nodeItem = MapView.this.getContainerItem().createNodeItem("New Node", MapView.this.pressedX, MapView.this.pressedY);
                MapView.this.callMapItemListeners(nodeItem, 3);
                MapView.this.creatingNode = false;
            }
            if (MapView.this.newArc instanceof MapItem) {
                NodeItem sinkNode;
                NodeItem nodeItem = sinkNode = this.item instanceof NodeItem ? (NodeItem)this.item : null;
                if (sinkNode instanceof NodeItem) {
                    MapView.this.newArc.setSinkNode(sinkNode);
                } else {
                    MapView.this.newArc.setSinkLocation(MapView.this.pressedX, MapView.this.pressedY);
                }
                MapView.this.callMapItemListeners(MapView.this.newArc, 3);
                MapView.this.newArc = null;
            }
            if (MapView.this.creatingArc) {
                NodeItem sourceNode = this.item instanceof NodeItem ? (NodeItem)this.item : null;
                MapView.this.newArc = MapView.this.getContainerItem().createArcItem(sourceNode, null, MapView.this.pressedX, MapView.this.pressedY);
                MapView.this.creatingArc = false;
            }
            if (this.item instanceof ArcItem) {
                ArcItem arcItem = (ArcItem)this.item;
                if (arcItem.isNearSourceLocation(MapView.this.pressedX, MapView.this.pressedY)) {
                    MapView.this.arcPoint = arcItem.getSourcePoint();
                } else if (arcItem.isNearSinkLocation(MapView.this.pressedX, MapView.this.pressedY)) {
                    MapView.this.arcPoint = arcItem.getSinkPoint();
                }
                if (MapView.this.arcPoint instanceof Point) {
                    MapView.this.selected.removeElement(arcItem);
                    MapView.this.movingArc = arcItem;
                }
            }
            MapView.this.repaint();
            this.maybePopup = event.isPopupTrigger();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            NodeItem nodeItem;
            MapView.this.dragged = false;
            MapView.this.dragMove = false;
            MapView.this.checkSelected(this.item, MapView.this.isMultiple(event));
            MapView.this.callMapItemListeners(MapView.this.selected, 0);
            if (this.maybePopup || event.isPopupTrigger()) {
                MapView.this.callMapItemListeners(event, 5);
            }
            if (MapView.this.arcPoint instanceof Point && (nodeItem = MapView.this.findNodeItem(MapView.this.arcPoint.x, MapView.this.arcPoint.y)) instanceof NodeItem) {
                if (MapView.this.movingArc.getSourcePoint() == MapView.this.arcPoint) {
                    MapView.this.movingArc.setSourceNode(nodeItem);
                } else if (MapView.this.movingArc.getSinkPoint() == MapView.this.arcPoint) {
                    MapView.this.movingArc.setSinkNode(nodeItem);
                }
            }
            MapView.this.movingArc = null;
            MapView.this.arcPoint = null;
            MapView.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            MapItem item = MapView.this.findMapItem(x, y);
            if (event.getClickCount() > 1) {
                if (item instanceof MapItem) {
                    if (MapView.this.nesting) {
                        MapView.this.setSelected(null, false);
                        MapView.this.containerItem = item;
                        MapView.this.updateView();
                    } else {
                        MapView.this.setSelected(item, false);
                    }
                } else if (MapView.this.containerItem instanceof MapItem && (item = (MapItem)MapView.this.containerItem.getItemParent()) instanceof MapItem) {
                    MapView.this.setSelected((MapItem)MapView.this.containerItem, false);
                    MapView.this.containerItem = item;
                    MapView.this.updateView();
                }
                MapView.this.callMapItemListeners(item, 2);
            }
            MapView.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            MapView.this.inView = true;
            MapView.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent event) {
            MapView.this.inView = false;
            MapView.this.repaint();
        }
    }

    protected class MapViewMouseMotionAdapter
    extends MouseMotionAdapter {
        protected MapViewMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            int width = Math.abs(x - MapView.this.pressedX);
            int height = Math.abs(y - MapView.this.pressedY);
            if (MapView.this.dragMove) {
                if (!MapView.this.dragged) {
                    MapView.this.reselect();
                }
                if (MapView.this.moving) {
                    if (MapView.this.arcPoint instanceof Point) {
                        MapView.this.arcPoint.setLocation(x, y);
                    }
                    int i = 0;
                    while (i < MapView.this.selected.size()) {
                        MapItem item = (MapItem)MapView.this.selected.elementAt(i);
                        item.translate(x - MapView.this.pressedX, y - MapView.this.pressedY);
                        ++i;
                    }
                    MapView.this.callMapItemListeners(MapView.this.selected, 1);
                }
                MapView.this.updateView();
                MapView.this.pressedX = x;
                MapView.this.pressedY = y;
            } else if (MapView.this.selecting) {
                MapView.this.selectBox.x = x < MapView.this.pressedX ? x : MapView.this.pressedX;
                MapView.this.selectBox.y = y < MapView.this.pressedY ? y : MapView.this.pressedY;
                MapView.this.selectBox.setSize(width, height);
                MapView.this.findMapItems(MapView.this.selectBox, MapView.this.selected, event.isShiftDown());
                MapView.this.repaint();
            }
            MapView.this.dragged = true;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (MapView.this.creatingNode || MapView.this.creatingArc || MapView.this.newArc instanceof ArcItem) {
                MapView.this.xMove = event.getX();
                MapView.this.yMove = event.getY();
                if (MapView.this.newArc instanceof ArcItem) {
                    MapView.this.newArc.setSinkLocation(MapView.this.xMove, MapView.this.yMove);
                }
                MapView.this.repaint();
            }
        }
    }
}

