/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.text;

import java.io.IOException;
import java.io.Reader;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;

public class TextReader
extends Reader
implements DocumentListener {
    protected JTextArea text;
    protected Document document;
    protected StringBuffer buffer;
    protected Thread inputWaitThread;
    private volatile boolean threadSuspended = false;

    public TextReader(JTextArea ta) {
        this.text = ta;
        this.document = this.text.getDocument();
        this.buffer = new StringBuffer("");
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        char[] cbuf = new char[1];
        this.read(cbuf);
        return cbuf[0];
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.document.addDocumentListener(this);
        try {
            TextReader textReader = this;
            synchronized (textReader) {
                this.threadSuspended = true;
                while (this.threadSuspended) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.buffer.getChars(0, len, cbuf, off);
        this.buffer = new StringBuffer(this.buffer.toString().substring(len));
        this.document.removeDocumentListener(this);
        return len;
    }

    @Override
    public boolean ready() throws IOException {
        return this.buffer.length() > 0;
    }

    public int available() throws IOException {
        return this.buffer.length();
    }

    @Override
    public void changedUpdate(DocumentEvent docEvent) {
        this.handleDocEvent(docEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent docEvent) {
        this.handleDocEvent(docEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent docEvent) {
        this.handleDocEvent(docEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDocEvent(DocumentEvent docEvent) {
        AbstractDocument doc = (AbstractDocument)docEvent.getDocument();
        int len = docEvent.getLength();
        int i = docEvent.getOffset();
        DocumentEvent.EventType det = docEvent.getType();
        try {
            String currentText = doc.getText(0, doc.getLength());
            int n = currentText.length();
            currentText = currentText.substring(n - 1, n);
            this.buffer.append(currentText);
            TextReader textReader = this;
            synchronized (textReader) {
                this.threadSuspended = false;
                this.notify();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("handleDOcEvent: " + e.toString());
        }
    }
}

