/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.util;

import java.awt.Graphics;

public class ArrowsDrawer {
    public static void drawArrow(Graphics g, float x1, float y1, float x2, float y2, float lineThickness) {
        ArrowsDrawer.drawArrow(g, x1, y1, x2, y2, lineThickness, 3.0f * lineThickness, 3.0f * lineThickness);
    }

    public static void drawArrow(Graphics g, float x1, float y1, float x2, float y2, float lineThickness, float arrowHeadLength, float arrowHeadWidth) {
        ArrowsDrawer.drawArrowInternal(g, x1, y1, x2, y2, lineThickness, arrowHeadLength, arrowHeadWidth, false);
    }

    public static void fillArrow(Graphics g, float x1, float y1, float x2, float y2, float lineThickness) {
        ArrowsDrawer.fillArrow(g, x1, y1, x2, y2, lineThickness, 3.0f * lineThickness, 3.0f * lineThickness);
    }

    public static void fillArrow(Graphics g, float x1, float y1, float x2, float y2, float lineThickness, float arrowHeadLength, float arrowHeadWidth) {
        ArrowsDrawer.drawArrowInternal(g, x1, y1, x2, y2, lineThickness, arrowHeadLength, arrowHeadWidth, true);
    }

    private static void drawArrowInternal(Graphics g, float x1, float y1, float x2, float y2, float lineThickness, float arrowHeadLength, float arrowHeadWidth, boolean fill) {
        int[] xpol = new int[7];
        int[] ypol = new int[7];
        float linePrX = x2 - x1;
        float linePrY = y2 - y1;
        float lineLen = (float)Math.sqrt(linePrX * linePrX + linePrY * linePrY);
        float wArrowHeadLength = arrowHeadLength / lineLen;
        float x3 = x2 - (float)Math.round(linePrX * wArrowHeadLength);
        float y3 = y2 - (float)Math.round(linePrY * wArrowHeadLength);
        float lineWidth = lineThickness;
        float wLineWidth = (lineWidth - 1.0f) / 2.0f / lineLen;
        xpol[0] = Math.round(x1 + linePrY * wLineWidth);
        ypol[0] = Math.round(y1 - linePrX * wLineWidth);
        xpol[6] = Math.round(x1 - linePrY * wLineWidth);
        ypol[6] = Math.round(y1 + linePrX * wLineWidth);
        xpol[1] = Math.round(x3 + linePrY * wLineWidth);
        ypol[1] = Math.round(y3 - linePrX * wLineWidth);
        xpol[5] = Math.round(x3 - linePrY * wLineWidth);
        ypol[5] = Math.round(y3 + linePrX * wLineWidth);
        float wArrowHeadWidth = arrowHeadWidth / lineLen;
        xpol[2] = Math.round(x3 + linePrY * wArrowHeadWidth / 2.0f);
        ypol[2] = Math.round(y3 - linePrX * wArrowHeadWidth / 2.0f);
        xpol[3] = Math.round(x2);
        ypol[3] = Math.round(y2);
        xpol[4] = Math.round(x3 - linePrY * wArrowHeadWidth / 2.0f);
        ypol[4] = Math.round(y3 + linePrX * wArrowHeadWidth / 2.0f);
        if (fill) {
            g.drawPolygon(xpol, ypol, 7);
            g.fillPolygon(xpol, ypol, 7);
        } else {
            g.drawPolygon(xpol, ypol, 7);
        }
    }

    public static void drawDashedArrow(Graphics g, float x1, float y1, float x2, float y2, float lineThickness) {
        ArrowsDrawer.drawDashedArrow(g, x1, y1, x2, y2, lineThickness, 3.0f * lineThickness, 3.0f * lineThickness);
    }

    public static void drawDashedArrow(Graphics g, float x1, float y1, float x2, float y2, float lineThickness, float arrowHeadLength, float arrowHeadWidth) {
        ArrowsDrawer.drawDashedArrowInternal(g, x1, y1, x2, y2, lineThickness, arrowHeadLength, arrowHeadWidth, false);
    }

    public static void fillDashedArrow(Graphics g, float x1, float y1, float x2, float y2, float lineThickness) {
        ArrowsDrawer.fillDashedArrow(g, x1, y1, x2, y2, lineThickness, 3.0f * lineThickness, 3.0f * lineThickness);
    }

    public static void fillDashedArrow(Graphics g, float x1, float y1, float x2, float y2, float lineThickness, float arrowHeadLength, float arrowHeadWidth) {
        ArrowsDrawer.drawDashedArrowInternal(g, x1, y1, x2, y2, lineThickness, arrowHeadLength, arrowHeadWidth, true);
    }

    private static void drawDashedArrowInternal(Graphics g, float x1, float y1, float x2, float y2, float lineThickness, float arrowHeadLength, float arrowHeadWidth, boolean fill) {
        int[] xpol = new int[3];
        int[] ypol = new int[3];
        float linePrX = x2 - x1;
        float linePrY = y2 - y1;
        float lineLen = (float)Math.sqrt(linePrX * linePrX + linePrY * linePrY);
        float wArrowHeadLength = arrowHeadLength / lineLen;
        float x3 = x2 - linePrX * wArrowHeadLength;
        float y3 = y2 - linePrY * wArrowHeadLength;
        if (fill) {
            ArrowsDrawer.fillDashedRect(g, x1, y1, x3, y3, lineThickness, lineThickness, lineThickness / 2.0f);
        } else {
            ArrowsDrawer.drawDashedRect(g, x1, y1, x3, y3, lineThickness, lineThickness, lineThickness / 2.0f);
        }
        xpol[0] = Math.round(x3 + linePrY * wArrowHeadLength / 2.0f);
        ypol[0] = Math.round(y3 - linePrX * wArrowHeadLength / 2.0f);
        xpol[1] = Math.round(x2);
        ypol[1] = Math.round(y2);
        xpol[2] = Math.round(x3 - linePrY * wArrowHeadLength / 2.0f);
        ypol[2] = Math.round(y3 + linePrX * wArrowHeadLength / 2.0f);
        if (fill) {
            g.fillPolygon(xpol, ypol, 3);
        } else {
            g.drawPolygon(xpol, ypol, 3);
        }
    }

    public static void drawRect(Graphics g, float x1, float y1, float x2, float y2, float rectWidth) {
        ArrowsDrawer.drawRectInternal(g, x1, y1, x2, y2, rectWidth, false);
    }

    public static void fillRect(Graphics g, float x1, float y1, float x2, float y2, float rectWidth) {
        ArrowsDrawer.drawRectInternal(g, x1, y1, x2, y2, rectWidth, true);
    }

    private static void drawRectInternal(Graphics g, float x1, float y1, float x2, float y2, float rectWidth, boolean fill) {
        int[] xpol = new int[4];
        int[] ypol = new int[4];
        float linePrX = x2 - x1;
        float linePrY = y2 - y1;
        float lineLen = (float)Math.sqrt(linePrX * linePrX + linePrY * linePrY);
        float lineWidth = rectWidth;
        float wLineWidth = lineWidth / 2.0f / lineLen;
        float x00 = x1 + linePrY * wLineWidth;
        float y00 = y1 - linePrX * wLineWidth;
        float x01 = x1 - linePrY * wLineWidth;
        float y01 = y1 + linePrX * wLineWidth;
        float x11 = x2 + linePrY * wLineWidth;
        float y11 = y2 - linePrX * wLineWidth;
        float x10 = x2 - linePrY * wLineWidth;
        float y10 = y2 + linePrX * wLineWidth;
        xpol[0] = Math.round(x00);
        ypol[0] = Math.round(y00);
        xpol[1] = Math.round(x01);
        ypol[1] = Math.round(y01);
        xpol[2] = Math.round(x10);
        ypol[2] = Math.round(y10);
        xpol[3] = Math.round(x11);
        ypol[3] = Math.round(y11);
        if (fill) {
            g.fillPolygon(xpol, ypol, 4);
        } else {
            g.drawPolygon(xpol, ypol, 4);
        }
    }

    public static void drawDashedRect(Graphics g, float x1, float y1, float x2, float y2, float rectWidth, float dashLength, float spaceLength) {
        ArrowsDrawer.drawDashedRectInternal(g, x1, y1, x2, y2, rectWidth, dashLength, spaceLength, false);
    }

    public static void fillDashedRect(Graphics g, float x1, float y1, float x2, float y2, float rectWidth, float dashLength, float spaceLength) {
        ArrowsDrawer.drawDashedRectInternal(g, x1, y1, x2, y2, rectWidth, dashLength, spaceLength, true);
    }

    private static void drawDashedRectInternal(Graphics g, float x1, float y1, float x2, float y2, float rectWidth, float dashLength, float spaceLength, boolean fill) {
        int[] xpol = new int[4];
        int[] ypol = new int[4];
        float linePrX = x2 - x1;
        float linePrY = y2 - y1;
        float lineLen = (float)Math.sqrt(linePrX * linePrX + linePrY * linePrY);
        float dashLen = dashLength;
        float spaceLen = spaceLength;
        float lineWidth = rectWidth;
        float wDashLen = dashLen / lineLen;
        float wSpaceLen = spaceLen / lineLen;
        float wLineWidth = lineWidth / 2.0f / lineLen;
        float x00 = x1 + linePrY * wLineWidth;
        float y00 = y1 - linePrX * wLineWidth;
        float x01 = x1 - linePrY * wLineWidth;
        float y01 = y1 + linePrX * wLineWidth;
        float xi = 0.0f;
        while (xi < lineLen) {
            float x10 = x01 + linePrX * wDashLen;
            float y10 = y01 + linePrY * wDashLen;
            float x11 = x00 + linePrX * wDashLen;
            float y11 = y00 + linePrY * wDashLen;
            if (xi + dashLen > lineLen) {
                x11 = x2 + linePrY * wLineWidth;
                y11 = y2 - linePrX * wLineWidth;
                x10 = x2 - linePrY * wLineWidth;
                y10 = y2 + linePrX * wLineWidth;
            }
            xi += dashLen;
            xpol[0] = Math.round(x00);
            ypol[0] = Math.round(y00);
            xpol[1] = Math.round(x01);
            ypol[1] = Math.round(y01);
            xpol[2] = Math.round(x10);
            ypol[2] = Math.round(y10);
            xpol[3] = Math.round(x11);
            ypol[3] = Math.round(y11);
            if (fill) {
                g.fillPolygon(xpol, ypol, 4);
            } else {
                g.drawPolygon(xpol, ypol, 4);
            }
            x00 = x11 + linePrX * wSpaceLen;
            y00 = y11 + linePrY * wSpaceLen;
            x01 = x10 + linePrX * wSpaceLen;
            y01 = y10 + linePrY * wSpaceLen;
            xi += spaceLen;
        }
    }
}

